/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;

    public StoredProcOutboundGateway(DataSource dataSource, String storedProcedureName) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.executor = new StoredProcExecutor(dataSource, storedProcedureName);
    }

    protected void onInit() {
        super.onInit();
        this.executor.afterPropertiesSet();
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object payload;
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(requestMessage);
        if (resultMap.isEmpty()) {
            payload = null;
        } else if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new MessageHandlingException(requestMessage, "Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'. ");
            }
            payload = resultMap;
        }
        return MessageBuilder.withPayload(payload).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        this.executor.setSqlParameters(sqlParameters);
    }

    public void setReturningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        this.executor.setReturningResultSetRowMappers(returningResultSetRowMappers);
    }

    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.executor.setIgnoreColumnMetaData(ignoreColumnMetaData);
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.executor.setReturnValueRequired(returnValueRequired);
    }

    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        this.executor.setProcedureParameters(procedureParameters);
    }

    public void setIsFunction(boolean isFunction) {
        this.executor.setFunction(isFunction);
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.executor.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    public void setUsePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        this.executor.setUsePayloadAsParameterSource(usePayloadAsParameterSource);
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.executor.setSkipUndeclaredResults(skipUndeclaredResults);
    }
}

