/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.StoredProcOutboundGateway;
import org.springframework.integration.jdbc.config.StoredProcParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class StoredProcOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanDefinitionBuilder parseHandler(Element gatewayElement, ParserContext parserContext) {
        String replyChannel;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StoredProcOutboundGateway.class);
        String dataSourceRef = gatewayElement.getAttribute("data-source");
        String storedProcedureName = gatewayElement.getAttribute("stored-procedure-name");
        builder.addConstructorArgReference(dataSourceRef);
        builder.addConstructorArgValue((Object)storedProcedureName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"is-function");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"ignore-column-meta-data");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"expect-single-result");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"return-value-required");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"use-payload-as-parameter-source");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"sql-parameter-source-factory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"skip-undeclared-results");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)gatewayElement, (String)"reply-timeout", (String)"sendTimeout");
        ManagedList<BeanDefinition> procedureParameterList = StoredProcParserUtils.getProcedureParameterBeanDefinitions(gatewayElement, parserContext);
        ManagedList<BeanDefinition> sqlParameterDefinitionList = StoredProcParserUtils.getSqlParameterDefinitionBeanDefinitions(gatewayElement, parserContext);
        ManagedMap<String, BeanDefinition> returningResultsetMap = StoredProcParserUtils.getReturningResultsetBeanDefinitions(gatewayElement, parserContext);
        if (!procedureParameterList.isEmpty()) {
            builder.addPropertyValue("procedureParameters", procedureParameterList);
        }
        if (!sqlParameterDefinitionList.isEmpty()) {
            builder.addPropertyValue("sqlParameters", sqlParameterDefinitionList);
        }
        if (!returningResultsetMap.isEmpty()) {
            builder.addPropertyValue("returningResultSetRowMappers", returningResultsetMap);
        }
        if (StringUtils.hasText((String)(replyChannel = gatewayElement.getAttribute("reply-channel")))) {
            builder.addPropertyReference("outputChannel", replyChannel);
        }
        return builder;
    }

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }
}

