/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcPollingChannelAdapter
extends IntegrationObjectSupport
implements MessageSource<Object> {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;

    @Deprecated
    public StoredProcPollingChannelAdapter(DataSource dataSource, String storedProcedureName) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.executor = new StoredProcExecutor(dataSource);
        this.executor.setStoredProcedureName(storedProcedureName);
    }

    public StoredProcPollingChannelAdapter(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    protected void onInit() throws Exception {
        super.onInit();
    }

    public Message<Object> receive() {
        Object payload = this.poll();
        if (payload == null) {
            return null;
        }
        return MessageBuilder.withPayload((Object)payload).build();
    }

    private Object poll() {
        Map<String, Object> payload;
        Map<String, ?> resultMap = this.doPoll();
        if (resultMap.isEmpty()) {
            payload = null;
        } else if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new MessagingException("Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'. ");
            }
            payload = resultMap;
        }
        return payload;
    }

    protected Map<String, ?> doPoll() {
        return this.executor.executeStoredProcedure();
    }

    public String getComponentType() {
        return "stored-proc:inbound-channel-adapter";
    }

    @Deprecated
    public void setStoredProcedureName(String storedProcedureName) {
        this.executor.setStoredProcedureName(storedProcedureName);
    }

    @Deprecated
    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.executor.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    @Deprecated
    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        this.executor.setSqlParameters(sqlParameters);
    }

    @Deprecated
    public void setReturningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        this.executor.setReturningResultSetRowMappers(returningResultSetRowMappers);
    }

    @Deprecated
    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.executor.setIgnoreColumnMetaData(ignoreColumnMetaData);
    }

    @Deprecated
    public void setReturnValueRequired(boolean returnValueRequired) {
        this.executor.setReturnValueRequired(returnValueRequired);
    }

    @Deprecated
    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        this.executor.setProcedureParameters(procedureParameters);
    }

    @Deprecated
    public void setFunction(boolean isFunction) {
        this.executor.setIsFunction(isFunction);
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    @Deprecated
    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.executor.setSkipUndeclaredResults(skipUndeclaredResults);
    }
}

