/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ExpressionEvaluatingSqlParameterSourceFactory
extends AbstractExpressionEvaluator
implements SqlParameterSourceFactory {
    private static final Log logger = LogFactory.getLog(ExpressionEvaluatingSqlParameterSourceFactory.class);
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final Object ERROR = new Object();
    private volatile Map<String, ?> staticParameters = Collections.unmodifiableMap(new HashMap());
    private volatile Map<String, Expression[]> parameterExpressions = new HashMap<String, Expression[]>();

    public void setStaticParameters(Map<String, ?> staticParameters) {
        this.staticParameters = staticParameters;
    }

    public void setParameterExpressions(Map<String, String> parameterExpressions) {
        HashMap<String, Expression[]> paramExpressions = new HashMap<String, Expression[]>(parameterExpressions.size());
        for (Map.Entry<String, String> entry : parameterExpressions.entrySet()) {
            String key = entry.getKey();
            String expression = entry.getValue();
            Expression[] expressions = new Expression[]{PARSER.parseExpression(expression), PARSER.parseExpression("#root.![" + expression + "]")};
            paramExpressions.put(key, expressions);
        }
        this.parameterExpressions = paramExpressions;
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters, this.parameterExpressions);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.getEvaluationContext().setVariable("staticParameters", this.staticParameters);
    }

    private final class ExpressionEvaluatingSqlParameterSource
    extends AbstractSqlParameterSource {
        private final Object input;
        private volatile Map<String, Object> values = new HashMap<String, Object>();
        private final Map<String, Expression[]> parameterExpressions;

        private ExpressionEvaluatingSqlParameterSource(Object input, Map<String, ?> staticParameters, Map<String, Expression[]> parameterExpressions) {
            this.input = input;
            this.parameterExpressions = parameterExpressions;
            this.values.putAll(staticParameters);
        }

        public Object getValue(String paramName) throws IllegalArgumentException {
            if (this.values.containsKey(paramName)) {
                return this.values.get(paramName);
            }
            if (!this.parameterExpressions.containsKey(paramName)) {
                Expression[] expressions = new Expression[]{PARSER.parseExpression(paramName), PARSER.parseExpression("#root.![" + paramName + "]")};
                ExpressionEvaluatingSqlParameterSourceFactory.this.parameterExpressions.put(paramName, expressions);
                this.parameterExpressions.put(paramName, expressions);
            }
            Expression expression = null;
            expression = this.input instanceof Collection ? this.parameterExpressions.get(paramName)[1] : this.parameterExpressions.get(paramName)[0];
            Object value = ExpressionEvaluatingSqlParameterSourceFactory.this.evaluateExpression(expression, this.input);
            this.values.put(paramName, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved expression " + expression + " to " + value));
            }
            return value;
        }

        public boolean hasValue(String paramName) {
            try {
                Object value = this.getValue(paramName);
                if (value == ERROR) {
                    return false;
                }
            }
            catch (ExpressionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not evaluate expression", (Throwable)e);
                }
                this.values.put(paramName, ERROR);
                return false;
            }
            return true;
        }
    }
}

