/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class JdbcMessageHandler
extends AbstractMessageHandler {
    private final NamedParameterJdbcOperations jdbcOperations;
    private volatile String updateSql;
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
    private volatile boolean keysGenerated;

    public JdbcMessageHandler(DataSource dataSource, String updateSql) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(dataSource);
        this.updateSql = updateSql;
    }

    public JdbcMessageHandler(JdbcOperations jdbcOperations, String updateSql) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations);
        this.updateSql = updateSql;
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    protected void handleMessageInternal(Message<?> message) throws MessageRejectedException, MessageHandlingException, MessageDeliveryException {
        List<? extends Map<String, Object>> keys = this.executeUpdateQuery(message, this.keysGenerated);
        if (this.logger.isDebugEnabled() && !keys.isEmpty()) {
            this.logger.debug((Object)("Generated keys: " + keys));
        }
    }

    protected List<? extends Map<String, Object>> executeUpdateQuery(Object obj, boolean keysGenerated) {
        MapSqlParameterSource updateParameterSource = new MapSqlParameterSource();
        if (this.sqlParameterSourceFactory != null) {
            updateParameterSource = this.sqlParameterSourceFactory.createParameterSource(obj);
        }
        if (keysGenerated) {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcOperations.update(this.updateSql, (SqlParameterSource)updateParameterSource, (KeyHolder)keyHolder);
            return keyHolder.getKeyList();
        }
        int updated = this.jdbcOperations.update(this.updateSql, (SqlParameterSource)updateParameterSource);
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap();
        map.put("UPDATED", (Object)updated);
        return Collections.singletonList(map);
    }
}

