/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import java.util.List;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.PollableJmsChannel;
import org.springframework.integration.jms.SubscribableJmsChannel;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsChannelFactoryBean
extends AbstractFactoryBean<AbstractJmsChannel>
implements SmartLifecycle,
DisposableBean {
    private volatile AbstractJmsChannel channel;
    private volatile List<ChannelInterceptor> interceptors;
    private final boolean messageDriven;
    private final JmsTemplate jmsTemplate = new JmsTemplate();
    private volatile AbstractMessageListenerContainer container;
    private volatile Class<? extends AbstractMessageListenerContainer> containerType;
    private volatile boolean acceptMessagesWhileStopping;
    private volatile boolean autoStartup = true;
    private volatile String cacheLevelName;
    private volatile String clientId;
    private volatile Integer concurrentConsumers;
    private volatile ConnectionFactory connectionFactory;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile DestinationResolver destinationResolver;
    private volatile String durableSubscriptionName;
    private volatile ErrorHandler errorHandler;
    private volatile ExceptionListener exceptionListener;
    private volatile Boolean exposeListenerSession;
    private volatile Integer idleTaskExecutionLimit;
    private volatile Integer maxConcurrentConsumers;
    private volatile Integer maxMessagesPerTask;
    private volatile String messageSelector;
    private volatile Integer phase;
    private volatile Boolean pubSubDomain;
    private volatile boolean pubSubNoLocal;
    private volatile Long receiveTimeout;
    private volatile Long recoveryInterval;
    private volatile int sessionAcknowledgeMode = 0;
    private volatile boolean sessionTransacted = true;
    private volatile boolean subscriptionDurable;
    private volatile Executor taskExecutor;
    private volatile PlatformTransactionManager transactionManager;
    private volatile String transactionName;
    private volatile Integer transactionTimeout;

    public JmsChannelFactoryBean() {
        this(true);
    }

    public JmsChannelFactoryBean(boolean messageDriven) {
        this.messageDriven = messageDriven;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.jmsTemplate.setDeliveryPersistent(deliveryPersistent);
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.jmsTemplate.setExplicitQosEnabled(explicitQosEnabled);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.jmsTemplate.setMessageConverter(messageConverter);
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.jmsTemplate.setMessageIdEnabled(messageIdEnabled);
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.jmsTemplate.setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setPriority(int priority) {
        this.jmsTemplate.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) {
        this.jmsTemplate.setTimeToLive(timeToLive);
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setCacheLevelName(String cacheLevelName) {
        this.cacheLevelName = cacheLevelName;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
    }

    public void setContainerType(Class<? extends AbstractMessageListenerContainer> containerType) {
        this.containerType = containerType;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
        this.jmsTemplate.setDestinationResolver(destinationResolver);
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
        this.jmsTemplate.setPubSubDomain(pubSubDomain);
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
        this.jmsTemplate.setPubSubNoLocal(pubSubNoLocal);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        this.jmsTemplate.setReceiveTimeout(receiveTimeout);
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
        this.jmsTemplate.setSessionAcknowledgeMode(sessionAcknowledgeMode);
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
        this.jmsTemplate.setSessionTransacted(sessionTransacted);
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public Class<?> getObjectType() {
        return this.channel != null ? ((Object)((Object)this.channel)).getClass() : AbstractJmsChannel.class;
    }

    protected AbstractJmsChannel createInstance() throws Exception {
        this.initializeJmsTemplate();
        if (this.messageDriven) {
            this.container = this.createContainer();
            this.channel = new SubscribableJmsChannel(this.container, this.jmsTemplate);
        } else {
            Assert.isTrue((!Boolean.TRUE.equals(this.pubSubDomain) ? 1 : 0) != 0, (String)"A JMS Topic-backed 'publish-subscribe-channel' must be message-driven.");
            this.channel = new PollableJmsChannel(this.jmsTemplate);
        }
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            this.channel.setInterceptors(this.interceptors);
        }
        this.channel.afterPropertiesSet();
        return this.channel;
    }

    private void initializeJmsTemplate() {
        Assert.isTrue((boolean)(this.destination != null ^ this.destinationName != null), (String)"Exactly one of destination or destinationName is required.");
        if (this.destination != null) {
            this.jmsTemplate.setDefaultDestination(this.destination);
        }
        if (this.destinationName != null) {
            this.jmsTemplate.setDefaultDestinationName(this.destinationName);
        }
    }

    private AbstractMessageListenerContainer createContainer() throws Exception {
        if (this.containerType == null) {
            this.containerType = DefaultMessageListenerContainer.class;
        }
        AbstractMessageListenerContainer container = this.containerType.newInstance();
        container.setAcceptMessagesWhileStopping(this.acceptMessagesWhileStopping);
        container.setAutoStartup(this.autoStartup);
        container.setClientId(this.clientId);
        container.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            container.setDestination(this.destination);
        }
        if (this.destinationName != null) {
            container.setDestinationName(this.destinationName);
        }
        if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        container.setDurableSubscriptionName(this.durableSubscriptionName);
        container.setErrorHandler(this.errorHandler);
        container.setExceptionListener(this.exceptionListener);
        if (this.exposeListenerSession != null) {
            container.setExposeListenerSession(this.exposeListenerSession.booleanValue());
        }
        container.setMessageSelector(this.messageSelector);
        if (this.phase != null) {
            container.setPhase(this.phase.intValue());
        }
        if (this.pubSubDomain != null) {
            container.setPubSubDomain(this.pubSubDomain.booleanValue());
        }
        container.setSessionAcknowledgeMode(this.sessionAcknowledgeMode);
        container.setSessionTransacted(this.sessionTransacted);
        container.setSubscriptionDurable(this.subscriptionDurable);
        if (container instanceof DefaultMessageListenerContainer) {
            DefaultMessageListenerContainer dmlc = (DefaultMessageListenerContainer)container;
            if (this.cacheLevelName != null) {
                dmlc.setCacheLevelName(this.cacheLevelName);
            }
            if (this.concurrentConsumers != null) {
                dmlc.setConcurrentConsumers(this.concurrentConsumers.intValue());
            }
            if (this.idleTaskExecutionLimit != null) {
                dmlc.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit.intValue());
            }
            if (this.maxConcurrentConsumers != null) {
                dmlc.setMaxConcurrentConsumers(this.maxConcurrentConsumers.intValue());
            }
            if (this.maxMessagesPerTask != null) {
                dmlc.setMaxMessagesPerTask(this.maxMessagesPerTask.intValue());
            }
            dmlc.setPubSubNoLocal(this.pubSubNoLocal);
            if (this.receiveTimeout != null) {
                dmlc.setReceiveTimeout(this.receiveTimeout.longValue());
            }
            if (this.recoveryInterval != null) {
                dmlc.setRecoveryInterval(this.recoveryInterval.longValue());
            }
            dmlc.setTaskExecutor(this.taskExecutor);
            dmlc.setTransactionManager(this.transactionManager);
            if (this.transactionName != null) {
                dmlc.setTransactionName(this.transactionName);
            }
            if (this.transactionTimeout != null) {
                dmlc.setTransactionTimeout(this.transactionTimeout.intValue());
            }
        } else if (container instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer smlc = (SimpleMessageListenerContainer)container;
            if (this.concurrentConsumers != null) {
                smlc.setConcurrentConsumers(this.concurrentConsumers.intValue());
            }
            smlc.setPubSubNoLocal(this.pubSubNoLocal);
            smlc.setTaskExecutor(this.taskExecutor);
        }
        return container;
    }

    public boolean isAutoStartup() {
        return this.channel instanceof SubscribableJmsChannel ? ((SubscribableJmsChannel)this.channel).isAutoStartup() : false;
    }

    public int getPhase() {
        return this.channel instanceof SubscribableJmsChannel ? ((SubscribableJmsChannel)this.channel).getPhase() : 0;
    }

    public boolean isRunning() {
        return this.channel instanceof SubscribableJmsChannel ? ((SubscribableJmsChannel)this.channel).isRunning() : false;
    }

    public void start() {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).start();
        }
    }

    public void stop() {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).stop(callback);
        }
    }

    protected void destroyInstance(AbstractJmsChannel instance) throws Exception {
        if (instance instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).destroy();
        }
    }
}

