/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.util.Assert;

public class JmsMessageDrivenEndpoint
extends AbstractEndpoint
implements DisposableBean {
    private final AbstractMessageListenerContainer listenerContainer;
    private final ChannelPublishingJmsMessageListener listener;

    public JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        Assert.notNull((Object)listenerContainer, (String)"listener container must not be null");
        Assert.notNull((Object)((Object)listener), (String)"listener must not be null");
        if (this.logger.isWarnEnabled() && listenerContainer.getMessageListener() != null) {
            this.logger.warn((Object)"The provided listener container already has a MessageListener implementation, but it will be overridden by the provided ChannelPublishingJmsMessageListener.");
        }
        listenerContainer.setMessageListener((Object)listener);
        this.listener = listener;
        this.listenerContainer = listenerContainer;
    }

    public String getComponentType() {
        return "jms:message-driven-channel-adapter";
    }

    protected void onInit() throws Exception {
        this.listener.afterPropertiesSet();
        if (!this.listenerContainer.isActive()) {
            this.listenerContainer.afterPropertiesSet();
        }
        this.listener.setComponentName(this.getComponentName());
    }

    protected void doStart() {
        if (!this.listenerContainer.isRunning()) {
            this.listenerContainer.start();
        }
    }

    protected void doStop() {
        this.listenerContainer.stop();
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.stop();
        }
        this.listenerContainer.destroy();
    }
}

