/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.Message;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel {
    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public Message<?> receive() {
        Object object = this.getJmsTemplate().receiveAndConvert();
        if (object == null) {
            return null;
        }
        if (object instanceof Message) {
            return (Message)object;
        }
        return MessageBuilder.withPayload((Object)object).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }
}

