/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class JmsAdapterParserUtils {
    static final String JMS_TEMPLATE_ATTRIBUTE = "jms-template";
    static final String JMS_TEMPLATE_PROPERTY = "jmsTemplate";
    static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    static final String CONNECTION_FACTORY_PROPERTY = "connectionFactory";
    static final String DESTINATION_ATTRIBUTE = "destination";
    static final String DESTINATION_PROPERTY = "destination";
    static final String DESTINATION_NAME_ATTRIBUTE = "destination-name";
    static final String PUB_SUB_DOMAIN_ATTRIBUTE = "pub-sub-domain";
    static final String PUB_SUB_DOMAIN_PROPERTY = "pubSubDomain";
    static final String DESTINATION_NAME_PROPERTY = "destinationName";
    static final String HEADER_MAPPER_ATTRIBUTE = "header-mapper";
    static final String HEADER_MAPPER_PROPERTY = "headerMapper";
    private static final String[] JMS_TEMPLATE_ATTRIBUTES = new String[]{"connection-factory", "message-converter", "destination-resolver", "pub-sub-domain", "time-to-live", "priority", "delivery-persistent", "explicit-qos-enabled", "acknowledge", "receive-timeout"};
    static final int SESSION_TRANSACTED = 0;
    private static final int AUTO_ACKNOWLEDGE = 1;
    private static final int CLIENT_ACKNOWLEDGE = 2;
    private static final int DUPS_OK_ACKNOWLEDGE = 3;

    JmsAdapterParserUtils() {
    }

    static String determineConnectionFactoryBeanName(Element element, ParserContext parserContext) {
        String connectionFactoryBeanName = CONNECTION_FACTORY_PROPERTY;
        if (element.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("JMS adapter 'connection-factory' attribute must not be empty", (Object)element);
        }
        return connectionFactoryBeanName;
    }

    static Integer parseAcknowledgeMode(Element element, ParserContext parserContext) {
        String acknowledge = element.getAttribute("acknowledge");
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if ("transacted".equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if ("dups-ok".equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if ("client".equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!"auto".equals(acknowledge)) {
                parserContext.getReaderContext().error("Invalid JMS 'acknowledge' setting: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.", (Object)element);
            }
            return acknowledgeMode;
        }
        return null;
    }

    static BeanDefinition parseJmsTemplateBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.jms.DynamicJmsTemplate");
        builder.addPropertyReference(CONNECTION_FACTORY_PROPERTY, JmsAdapterParserUtils.determineConnectionFactoryBeanName(element, parserContext));
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)PUB_SUB_DOMAIN_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"priority");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delivery-persistent");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"explicit-qos-enabled");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        Integer acknowledgeMode = JmsAdapterParserUtils.parseAcknowledgeMode(element, parserContext);
        if (acknowledgeMode != null) {
            builder.addPropertyValue("sessionAcknowledgeMode", (Object)acknowledgeMode);
        }
        return builder.getBeanDefinition();
    }

    static void verifyNoJmsTemplateAttributes(Element element, ParserContext parserContext) {
        for (String attributeName : JMS_TEMPLATE_ATTRIBUTES) {
            if (!element.hasAttribute(attributeName)) continue;
            parserContext.getReaderContext().error("When providing a 'jms-template' reference, the '" + attributeName + "' attribute is not allowed", parserContext.extractSource((Object)element));
        }
    }
}

