/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;

public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel {
    private volatile String messageSelector;

    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public Message<?> receive() {
        if (!this.getInterceptors().preReceive((MessageChannel)this)) {
            return null;
        }
        Object object = this.messageSelector == null ? this.getJmsTemplate().receiveAndConvert() : this.getJmsTemplate().receiveSelectedAndConvert(this.messageSelector);
        if (object == null) {
            return null;
        }
        Message replyMessage = null;
        replyMessage = object instanceof Message ? (Message)object : MessageBuilder.withPayload((Object)object).build();
        return this.getInterceptors().postReceive(replyMessage, (MessageChannel)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }
}

