/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class DynamicJmsTemplate
extends JmsTemplate {
    public int getPriority() {
        Integer priority = DynamicJmsTemplateProperties.getPriority();
        if (priority == null) {
            return super.getPriority();
        }
        Assert.isTrue((priority >= 0 && priority <= 9 ? 1 : 0) != 0, (String)"JMS priority must be in the range of 0-9");
        return priority;
    }

    public long getReceiveTimeout() {
        Long receiveTimeout = DynamicJmsTemplateProperties.getReceiveTimeout();
        return receiveTimeout != null ? receiveTimeout.longValue() : super.getReceiveTimeout();
    }
}

