/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsSendingMessageHandler;
import org.springframework.integration.jms.dsl.JmsTemplateSpec;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class JmsOutboundChannelAdapterSpec<S extends JmsOutboundChannelAdapterSpec<S>>
extends MessageHandlerSpec<S, JmsSendingMessageHandler> {
    protected final JmsTemplateSpec jmsTemplateSpec = new JmsTemplateSpec();

    JmsOutboundChannelAdapterSpec(JmsTemplate jmsTemplate) {
        this.target = new JmsSendingMessageHandler(jmsTemplate);
    }

    private JmsOutboundChannelAdapterSpec(ConnectionFactory connectionFactory) {
        this.target = new JmsSendingMessageHandler((JmsTemplate)((JmsTemplateSpec)((Object)this.jmsTemplateSpec.connectionFactory(connectionFactory))).get());
    }

    public S extractPayload(boolean extractPayload) {
        ((JmsSendingMessageHandler)((Object)this.target)).setExtractPayload(extractPayload);
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public S headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsSendingMessageHandler)((Object)this.target)).setHeaderMapper(headerMapper);
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public S destination(Destination destination) {
        ((JmsSendingMessageHandler)((Object)this.target)).setDestination(destination);
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public S destination(String destination) {
        ((JmsSendingMessageHandler)((Object)this.target)).setDestinationName(destination);
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public S destinationExpression(String destination) {
        ((JmsSendingMessageHandler)((Object)this.target)).setDestinationExpression(PARSER.parseExpression(destination));
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public <P> S destination(Function<Message<P>, ?> destinationFunction) {
        ((JmsSendingMessageHandler)((Object)this.target)).setDestinationExpression((Expression)new FunctionExpression(destinationFunction));
        return (S)((Object)((JmsOutboundChannelAdapterSpec)this._this()));
    }

    public static class JmsOutboundChannelSpecTemplateAware
    extends JmsOutboundChannelAdapterSpec<JmsOutboundChannelSpecTemplateAware>
    implements ComponentsRegistration {
        JmsOutboundChannelSpecTemplateAware(ConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        public JmsOutboundChannelSpecTemplateAware configureJmsTemplate(Consumer<JmsTemplateSpec> configurer) {
            Assert.notNull(configurer, (String)"'configurer' must not be null");
            configurer.accept(this.jmsTemplateSpec);
            return (JmsOutboundChannelSpecTemplateAware)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(this.jmsTemplateSpec.get(), this.jmsTemplateSpec.getId());
        }
    }
}

