/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.messaging.MessageChannel;

public class JmsInboundGateway
extends MessagingGatewaySupport
implements DisposableBean,
OrderlyShutdownCapable {
    private final JmsMessageDrivenEndpoint endpoint;

    public JmsInboundGateway(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this.endpoint = new JmsMessageDrivenEndpoint(listenerContainer, listener);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        super.setRequestChannel(requestChannel);
        this.endpoint.getListener().setRequestChannel(requestChannel);
    }

    public void setShutdownContainerOnStop(boolean shutdownContainerOnStop) {
        this.endpoint.setShutdownContainerOnStop(shutdownContainerOnStop);
    }

    public String getComponentType() {
        return this.endpoint.getComponentType();
    }

    public void setComponentName(String componentName) {
        super.setComponentName(componentName);
        this.endpoint.setComponentName(this.getComponentName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.endpoint.setApplicationContext(applicationContext);
        this.endpoint.setBeanFactory((BeanFactory)applicationContext);
        this.endpoint.getListener().setBeanFactory((BeanFactory)applicationContext);
    }

    protected void onInit() throws Exception {
        this.endpoint.afterPropertiesSet();
    }

    public ChannelPublishingJmsMessageListener getListener() {
        return this.endpoint.getListener();
    }

    protected void doStart() {
        this.endpoint.start();
    }

    protected void doStop() {
        this.endpoint.stop();
    }

    public void destroy() throws Exception {
        this.endpoint.destroy();
        super.destroy();
    }

    public int beforeShutdown() {
        return this.endpoint.beforeShutdown();
    }

    public int afterShutdown() {
        return this.endpoint.afterShutdown();
    }
}

