/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.monitor.DirectChannelMetrics;
import org.springframework.integration.monitor.LifecycleMessageHandlerMetrics;
import org.springframework.integration.monitor.LifecycleMessageSourceMetrics;
import org.springframework.integration.monitor.MessageChannelMetrics;
import org.springframework.integration.monitor.MessageHandlerMetrics;
import org.springframework.integration.monitor.MessageSourceMetrics;
import org.springframework.integration.monitor.PollableChannelMetrics;
import org.springframework.integration.monitor.QueueChannelMetrics;
import org.springframework.integration.monitor.SimpleMessageHandlerMetrics;
import org.springframework.integration.monitor.SimpleMessageSourceMetrics;
import org.springframework.integration.monitor.Statistics;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MetricType;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class IntegrationMBeanExporter
extends MBeanExporter
implements BeanPostProcessor,
BeanFactoryAware,
BeanClassLoaderAware,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(IntegrationMBeanExporter.class);
    public static final String DEFAULT_DOMAIN = "org.springframework.integration";
    private final AnnotationJmxAttributeSource attributeSource = new AnnotationJmxAttributeSource();
    private ListableBeanFactory beanFactory;
    private Map<Object, AtomicLong> anonymousHandlerCounters = new HashMap<Object, AtomicLong>();
    private Map<Object, AtomicLong> anonymousSourceCounters = new HashMap<Object, AtomicLong>();
    private Set<SimpleMessageHandlerMetrics> handlers = new HashSet<SimpleMessageHandlerMetrics>();
    private Set<SimpleMessageSourceMetrics> sources = new HashSet<SimpleMessageSourceMetrics>();
    private Set<DirectChannelMetrics> channels = new HashSet<DirectChannelMetrics>();
    private Map<String, DirectChannelMetrics> channelsByName = new HashMap<String, DirectChannelMetrics>();
    private Map<String, MessageHandlerMetrics> handlersByName = new HashMap<String, MessageHandlerMetrics>();
    private Map<String, MessageSourceMetrics> sourcesByName = new HashMap<String, MessageSourceMetrics>();
    private ClassLoader beanClassLoader;
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private String domain = "org.springframework.integration";
    private final Map<String, String> objectNameStaticProperties = new HashMap<String, String>();

    public IntegrationMBeanExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource));
        this.setAssembler((MBeanInfoAssembler)new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
        super.setBeanClassLoader(classLoader);
    }

    public void setObjectNameStaticProperties(Map<String, String> objectNameStaticProperties) {
        this.objectNameStaticProperties.putAll(objectNameStaticProperties);
    }

    public void setDefaultDomain(String domain) {
        this.domain = domain;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        Assert.isTrue((boolean)(beanFactory instanceof ListableBeanFactory), (String)"A ListableBeanFactory is required.");
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MethodInterceptor monitor;
        if (bean instanceof Advised) {
            for (Advisor advisor : ((Advised)bean).getAdvisors()) {
                Advice advice = advisor.getAdvice();
                if (!(advice instanceof MessageHandlerMetrics) && !(advice instanceof MessageSourceMetrics) && !(advice instanceof MessageChannelMetrics)) continue;
                return bean;
            }
        }
        if (bean instanceof MessageHandler) {
            monitor = new SimpleMessageHandlerMetrics((MessageHandler)bean);
            Object advised = this.applyHandlerInterceptor(bean, (SimpleMessageHandlerMetrics)monitor, this.beanClassLoader);
            this.handlers.add((SimpleMessageHandlerMetrics)monitor);
            return advised;
        }
        if (bean instanceof MessageSource) {
            monitor = new SimpleMessageSourceMetrics((MessageSource)bean);
            Object advised = this.applySourceInterceptor(bean, (SimpleMessageSourceMetrics)monitor, this.beanClassLoader);
            this.sources.add((SimpleMessageSourceMetrics)monitor);
            return advised;
        }
        if (bean instanceof MessageChannel) {
            Object target;
            monitor = bean instanceof PollableChannel ? ((target = this.extractTarget(bean)) instanceof QueueChannel ? new QueueChannelMetrics((QueueChannel)target, beanName) : new PollableChannelMetrics(beanName)) : new DirectChannelMetrics(beanName);
            Object advised = this.applyChannelInterceptor(bean, (DirectChannelMetrics)monitor, this.beanClassLoader);
            this.channels.add((DirectChannelMetrics)monitor);
            return advised;
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void registerBeans() {
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("started " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("stopped " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doStop() {
        this.unregisterBeans();
        this.channelsByName.clear();
        this.handlersByName.clear();
        this.sourcesByName.clear();
    }

    protected void doStart() {
        this.registerChannels();
        this.registerHandlers();
        this.registerSources();
    }

    public void destroy() {
        super.destroy();
        for (DirectChannelMetrics directChannelMetrics : this.channels) {
            logger.info((Object)("Summary on shutdown: " + directChannelMetrics));
        }
        for (SimpleMessageHandlerMetrics simpleMessageHandlerMetrics : this.handlers) {
            logger.info((Object)("Summary on shutdown: " + simpleMessageHandlerMetrics));
        }
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Channel Count")
    public int getChannelCount() {
        return this.channelsByName.size();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageHandler Handler Count")
    public int getHandlerCount() {
        return this.handlersByName.size();
    }

    @ManagedAttribute
    public String[] getHandlerNames() {
        return this.handlersByName.keySet().toArray(new String[0]);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Active Handler Count")
    public int getActiveHandlerCount() {
        int count = 0;
        for (SimpleMessageHandlerMetrics monitor : this.handlers) {
            count += monitor.getActiveCount();
        }
        return count;
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Queued Message Count")
    public int getQueuedMessageCount() {
        int count = 0;
        for (DirectChannelMetrics monitor : this.channels) {
            if (!(monitor instanceof QueueChannelMetrics)) continue;
            count += ((QueueChannelMetrics)monitor).getQueueSize();
        }
        return count;
    }

    @ManagedAttribute
    public String[] getChannelNames() {
        return this.channelsByName.keySet().toArray(new String[0]);
    }

    public Statistics getHandlerDuration(String name) {
        if (this.handlersByName.containsKey(name)) {
            return this.handlersByName.get(name).getDuration();
        }
        logger.debug((Object)("No handler found for (" + name + ")"));
        return null;
    }

    public int getChannelReceiveCount(String name) {
        if (this.channelsByName.containsKey(name) && this.channelsByName.get(name) instanceof PollableChannelMetrics) {
            return ((PollableChannelMetrics)this.channelsByName.get(name)).getReceiveCount();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return -1;
    }

    @ManagedOperation
    public Statistics getChannelSendRate(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getSendRate();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return null;
    }

    public Statistics getChannelErrorRate(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getErrorRate();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return null;
    }

    private void registerChannels() {
        for (DirectChannelMetrics monitor : this.channels) {
            String name = monitor.getName();
            if (this.channelsByName.containsKey(name)) continue;
            String beanKey = this.getChannelBeanKey(name);
            logger.info((Object)("Registering MessageChannel " + name));
            if (name != null) {
                this.channelsByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
        }
    }

    private void registerHandlers() {
        for (SimpleMessageHandlerMetrics source : this.handlers) {
            MessageHandlerMetrics monitor = this.enhanceHandlerMonitor(source);
            String name = monitor.getName();
            if (this.handlersByName.containsKey(name)) continue;
            String beanKey = this.getHandlerBeanKey(monitor);
            if (name != null) {
                this.handlersByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
        }
    }

    private void registerSources() {
        for (SimpleMessageSourceMetrics source : this.sources) {
            MessageSourceMetrics monitor = this.enhanceSourceMonitor(source);
            String name = monitor.getName();
            if (this.sourcesByName.containsKey(name)) continue;
            String beanKey = this.getSourceBeanKey(monitor);
            if (name != null) {
                this.sourcesByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
        }
    }

    private Object applyChannelInterceptor(Object bean, DirectChannelMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor channelsAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        channelsAdvice.addMethodName("send");
        channelsAdvice.addMethodName("receive");
        return this.applyAdvice(bean, (PointcutAdvisor)channelsAdvice, beanClassLoader);
    }

    private Object applyHandlerInterceptor(Object bean, SimpleMessageHandlerMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor handlerAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        handlerAdvice.addMethodName("handleMessage");
        return this.applyAdvice(bean, (PointcutAdvisor)handlerAdvice, beanClassLoader);
    }

    private Object applySourceInterceptor(Object bean, SimpleMessageSourceMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor sourceAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        sourceAdvice.addMethodName("receive");
        return this.applyAdvice(bean, (PointcutAdvisor)sourceAdvice, beanClassLoader);
    }

    private Object extractTarget(Object bean) {
        if (!(bean instanceof Advised)) {
            return bean;
        }
        Advised advised = (Advised)bean;
        if (advised.getTargetSource() == null) {
            return null;
        }
        try {
            return this.extractTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            logger.error((Object)"Could not extract target", (Throwable)e);
            return null;
        }
    }

    private Object applyAdvice(Object bean, PointcutAdvisor advisor, ClassLoader beanClassLoader) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (AopUtils.canApply((Pointcut)advisor.getPointcut(), (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor((Advisor)advisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.addAdvisor((Advisor)advisor);
            return proxyFactory.getProxy(beanClassLoader);
        }
        return bean;
    }

    private String getChannelBeanKey(String channel) {
        String name = "" + channel;
        if (name.startsWith(DEFAULT_DOMAIN)) {
            name = name + ",source=anonymous";
        }
        return String.format(this.domain + ":type=MessageChannel,name=%s" + this.getStaticNames(), name);
    }

    private String getHandlerBeanKey(MessageHandlerMetrics handler) {
        return String.format(this.domain + ":type=MessageHandler,name=%s,bean=%s" + this.getStaticNames(), handler.getName(), handler.getSource());
    }

    private String getSourceBeanKey(MessageSourceMetrics handler) {
        return String.format(this.domain + ":type=MessageSource,name=%s,bean=%s" + this.getStaticNames(), handler.getName(), handler.getSource());
    }

    private String getStaticNames() {
        if (this.objectNameStaticProperties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String key : this.objectNameStaticProperties.keySet()) {
            builder.append("," + key + "=" + this.objectNameStaticProperties.get(key));
        }
        return builder.toString();
    }

    private MessageHandlerMetrics enhanceHandlerMonitor(SimpleMessageHandlerMetrics monitor) {
        MessageHandlerMetrics result = monitor;
        if (monitor.getName() != null && monitor.getSource() != null) {
            return monitor;
        }
        String[] names = this.beanFactory.getBeanNamesForType(AbstractEndpoint.class);
        String name = null;
        String source = "endpoint";
        Object endpoint = null;
        for (String beanName : names) {
            endpoint = this.beanFactory.getBean(beanName);
            Object field = null;
            try {
                field = this.extractTarget(IntegrationMBeanExporter.getField(endpoint, "handler"));
            }
            catch (Exception e) {
                logger.trace((Object)("Could not get handler from bean = " + beanName));
            }
            if (field != monitor.getMessageHandler()) continue;
            name = beanName;
            break;
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = name.substring("_org.springframework.integration".length() + 1);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN)) {
            Object field;
            TargetSource targetSource;
            Object target = endpoint;
            if (endpoint instanceof Advised && (targetSource = ((Advised)endpoint).getTargetSource()) != null) {
                try {
                    target = targetSource.getTarget();
                }
                catch (Exception e) {
                    logger.debug((Object)("Could not get handler from bean = " + name));
                }
            }
            if ((field = IntegrationMBeanExporter.getField(target, "inputChannel")) != null) {
                if (!this.anonymousHandlerCounters.containsKey(field)) {
                    this.anonymousHandlerCounters.put(field, new AtomicLong());
                }
                AtomicLong count = this.anonymousHandlerCounters.get(field);
                long total = count.incrementAndGet();
                String suffix = "";
                if (total > 1L) {
                    suffix = "#" + total;
                }
                name = field + suffix;
                source = "anonymous";
            }
        }
        if (endpoint instanceof Lifecycle) {
            result = new LifecycleMessageHandlerMetrics((Lifecycle)endpoint, monitor);
        }
        if (name == null) {
            name = monitor.getMessageHandler().toString();
            source = "handler";
        }
        monitor.setSource(source);
        monitor.setName(name);
        return result;
    }

    private MessageSourceMetrics enhanceSourceMonitor(SimpleMessageSourceMetrics monitor) {
        MessageSourceMetrics result = monitor;
        if (monitor.getName() != null && monitor.getSource() != null) {
            return monitor;
        }
        String[] names = this.beanFactory.getBeanNamesForType(AbstractEndpoint.class);
        String name = null;
        String source = "endpoint";
        Object endpoint = null;
        for (String beanName : names) {
            endpoint = this.beanFactory.getBean(beanName);
            Object field = null;
            try {
                field = this.extractTarget(IntegrationMBeanExporter.getField(endpoint, "source"));
            }
            catch (Exception e) {
                logger.trace((Object)("Could not get source from bean = " + beanName));
            }
            if (field != monitor.getMessageSource()) continue;
            name = beanName;
            break;
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = name.substring("_org.springframework.integration".length() + 1);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN)) {
            Object field;
            TargetSource targetSource;
            Object target = endpoint;
            if (endpoint instanceof Advised && (targetSource = ((Advised)endpoint).getTargetSource()) != null) {
                try {
                    target = targetSource.getTarget();
                }
                catch (Exception e) {
                    logger.debug((Object)("Could not get handler from bean = " + name));
                }
            }
            if ((field = IntegrationMBeanExporter.getField(target, "outputChannel")) != null) {
                if (!this.anonymousSourceCounters.containsKey(field)) {
                    this.anonymousSourceCounters.put(field, new AtomicLong());
                }
                AtomicLong count = this.anonymousSourceCounters.get(field);
                long total = count.incrementAndGet();
                String suffix = "";
                if (total > 1L) {
                    suffix = "#" + total;
                }
                name = field + suffix;
                source = "anonymous";
            }
        }
        if (endpoint instanceof Lifecycle) {
            result = new LifecycleMessageSourceMetrics((Lifecycle)endpoint, monitor);
        }
        if (name == null) {
            name = monitor.getMessageSource().toString();
            source = "handler";
        }
        monitor.setSource(source);
        monitor.setName(name);
        return result;
    }

    private static Object getField(Object target, String name) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }
}

