/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MBeanExporterHelper
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
InitializingBean {
    private final Set<String> siBeanNames = new HashSet<String>();
    private volatile DefaultListableBeanFactory beanFactory;
    private volatile boolean capturedAutoChannelCandidates;

    MBeanExporterHelper() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory != null) {
            String[] beanNames;
            for (String beanName : beanNames = this.beanFactory.getBeanDefinitionNames()) {
                BeanDefinition def = this.beanFactory.getBeanDefinition(beanName);
                String className = def.getBeanClassName();
                if (className == null && def.getSource() instanceof StandardMethodMetadata) {
                    className = ((StandardMethodMetadata)def.getSource()).getIntrospectedMethod().getReturnType().getName();
                }
                if (!StringUtils.hasText((String)className) || !className.startsWith("org.springframework.integration") || className.endsWith(IntegrationMBeanExporter.class.getName())) continue;
                this.siBeanNames.add(beanName);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.capturedAutoChannelCandidates && this.beanFactory != null) {
            Object autoCreateChannelCandidates = this.beanFactory.getBean("$autoCreateChannelCandidates");
            if (autoCreateChannelCandidates != null) {
                Collection autoCreateChannelCandidatesNames = (Collection)new DirectFieldAccessor(autoCreateChannelCandidates).getPropertyValue("channelNames");
                this.siBeanNames.addAll(autoCreateChannelCandidatesNames);
            }
            this.capturedAutoChannelCandidates = true;
        }
        if (bean instanceof MBeanExporter && !(bean instanceof IntegrationMBeanExporter)) {
            MBeanExporter mbeanExporter = (MBeanExporter)bean;
            for (String siBean : this.siBeanNames) {
                mbeanExporter.addExcludedBean(siBean);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

