/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.listener;

import java.nio.ByteBuffer;
import java.util.Map;
import kafka.serializer.Decoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.integration.kafka.util.LoggingUtils;

public class LongSerializerDecoder
implements Serializer<Long>,
Decoder<Long> {
    private Log log = LogFactory.getLog(LongSerializerDecoder.class);

    public Long fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        try {
            return ByteBuffer.wrap(bytes).getLong(0);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot decode value: " + LoggingUtils.asCommaSeparatedHexDump(bytes)));
            }
            return null;
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, Long data) {
        if (data == null) {
            return null;
        }
        return ByteBuffer.allocate(8).putLong(data).array();
    }

    public void close() {
    }
}

