/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.integration.kafka.support.ProducerListener;
import org.springframework.integration.kafka.support.ProducerListenerInvokingCallback;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProducerConfiguration<K, V> {
    private final Producer<K, V> producer;
    private final ProducerMetadata<K, V> producerMetadata;
    private ConversionService conversionService;
    private ProducerListener producerListener;

    public ProducerConfiguration(ProducerMetadata<K, V> producerMetadata, Producer<K, V> producer) {
        Assert.notNull(producerMetadata);
        Assert.notNull(producer);
        this.producerMetadata = producerMetadata;
        this.producer = producer;
        GenericConversionService genericConversionService = new GenericConversionService();
        genericConversionService.addConverter((GenericConverter)new StringBytesConverter());
        genericConversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        this.conversionService = genericConversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"Conversion service must not be null");
        this.conversionService = conversionService;
    }

    public void setProducerListener(ProducerListener producerListener) {
        this.producerListener = producerListener;
    }

    public ProducerMetadata<K, V> getProducerMetadata() {
        return this.producerMetadata;
    }

    public Future<RecordMetadata> send(String topic, K messageKey, V messagePayload) {
        if (this.getProducerMetadata().getPartitioner() != null) {
            String targetTopic = StringUtils.hasText((String)topic) ? topic : this.producerMetadata.getTopic();
            int partition = this.getProducerMetadata().getPartitioner().partition(messageKey, this.producer.partitionsFor(targetTopic).size());
            return this.send(targetTopic, partition, messageKey, messagePayload);
        }
        return this.send(topic, null, messageKey, messagePayload);
    }

    public Future<RecordMetadata> send(String topic, Integer partition, K messageKey, V messagePayload) {
        Future future;
        String targetTopic;
        String string = targetTopic = StringUtils.hasText((String)topic) ? topic : this.producerMetadata.getTopic();
        if (partition == null && this.getProducerMetadata().getPartitioner() != null) {
            partition = this.getProducerMetadata().getPartitioner().partition(messageKey, this.producer.partitionsFor(targetTopic).size());
        }
        ProducerRecord record = new ProducerRecord(targetTopic, partition, messageKey, messagePayload);
        if (this.producerListener == null) {
            future = this.producer.send(record);
        } else {
            ProducerListenerInvokingCallback callback = new ProducerListenerInvokingCallback(targetTopic, partition, messageKey, messagePayload, this.producerListener);
            future = this.producer.send(record, (Callback)callback);
        }
        if (!this.producerMetadata.isSync()) {
            return future;
        }
        try {
            if (this.producerMetadata.getSendTimeout() <= 0) {
                future.get();
            } else {
                future.get(this.producerMetadata.getSendTimeout(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new KafkaException((Throwable)e);
        }
        return future;
    }

    public Future<RecordMetadata> convertAndSend(String topic, Integer partition, Object messageKey, Object messagePayload) {
        return this.send(topic, partition, this.convertKeyIfNecessary(messageKey), this.convertPayloadIfNecessary(messagePayload));
    }

    public Future<RecordMetadata> convertAndSend(String topic, Object messageKey, Object messagePayload) {
        return this.send(topic, this.convertKeyIfNecessary(messageKey), this.convertPayloadIfNecessary(messagePayload));
    }

    private K convertKeyIfNecessary(Object messageKey) {
        if (messageKey != null) {
            if (this.getProducerMetadata().getKeyClassType().isAssignableFrom(messageKey.getClass())) {
                return this.getProducerMetadata().getKeyClassType().cast(messageKey);
            }
            return (K)this.conversionService.convert(messageKey, this.producerMetadata.getKeyClassType());
        }
        return null;
    }

    private V convertPayloadIfNecessary(Object messagePayload) {
        if (messagePayload != null) {
            if (this.getProducerMetadata().getValueClassType().isAssignableFrom(messagePayload.getClass())) {
                return this.getProducerMetadata().getValueClassType().cast(messagePayload);
            }
            return (V)this.conversionService.convert(messagePayload, this.producerMetadata.getValueClassType());
        }
        return null;
    }

    public void stop() {
        this.producer.close();
    }

    public String toString() {
        return "ProducerConfiguration{producer=" + this.producer + ", producerMetadata=" + this.producerMetadata + ", conversionService=" + this.conversionService + '}';
    }

    private class StringBytesConverter
    implements GenericConverter {
        private StringBytesConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
            convertiblePairs.add(new GenericConverter.ConvertiblePair(String.class, byte[].class));
            convertiblePairs.add(new GenericConverter.ConvertiblePair(byte[].class, String.class));
            return convertiblePairs;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source instanceof String) {
                return ((String)source).getBytes(ProducerConfiguration.this.producerMetadata.getCharset());
            }
            return new String((byte[])source, ProducerConfiguration.this.producerMetadata.getCharset());
        }
    }
}

