/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KafkaProducerMessageHandler<K, V>
extends AbstractMessageHandler {
    private final KafkaTemplate<K, V> kafkaTemplate;
    private EvaluationContext evaluationContext;
    private volatile Expression topicExpression;
    private volatile Expression messageKeyExpression;
    private volatile Expression partitionIdExpression;

    public KafkaProducerMessageHandler(KafkaTemplate<K, V> kafkaTemplate) {
        Assert.notNull(kafkaTemplate, (String)"kafkaTemplate cannot be null");
        this.kafkaTemplate = kafkaTemplate;
    }

    public void setTopicExpression(Expression topicExpression) {
        this.topicExpression = topicExpression;
    }

    public void setMessageKeyExpression(Expression messageKeyExpression) {
        this.messageKeyExpression = messageKeyExpression;
    }

    public void setPartitionIdExpression(Expression partitionIdExpression) {
        this.partitionIdExpression = partitionIdExpression;
    }

    public KafkaTemplate<?, ?> getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object messageKey;
        String topic = this.topicExpression != null ? (String)this.topicExpression.getValue(this.evaluationContext, message, String.class) : (String)message.getHeaders().get((Object)"kafka_topic", String.class);
        Assert.state((boolean)StringUtils.hasText((String)topic), (String)"The 'topic' can not be empty or null");
        Integer partitionId = this.partitionIdExpression != null ? (Integer)this.partitionIdExpression.getValue(this.evaluationContext, message, Integer.class) : (Integer)message.getHeaders().get((Object)"kafka_partitionId", Integer.class);
        Object object = messageKey = this.messageKeyExpression != null ? this.messageKeyExpression.getValue(this.evaluationContext, message) : message.getHeaders().get((Object)"kafka_messageKey");
        if (partitionId == null) {
            if (messageKey == null) {
                this.kafkaTemplate.send(topic, message.getPayload());
            } else {
                this.kafkaTemplate.send(topic, messageKey, message.getPayload());
            }
        } else if (messageKey == null) {
            this.kafkaTemplate.send(topic, partitionId.intValue(), message.getPayload());
        } else {
            this.kafkaTemplate.send(topic, partitionId.intValue(), messageKey, message.getPayload());
        }
    }

    public String getComponentType() {
        return "kafka:outbound-channel-adapter";
    }
}

