/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import com.sun.mail.imap.IMAPFolder;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.util.Assert;

public class ImapMailReceiver
extends AbstractMailReceiver {
    private volatile boolean shouldDeleteMessages = true;
    private final MessageCountListener messageCountListener = new SimpleMessageCountListener();

    public ImapMailReceiver(String url) {
        super(url);
        Assert.isTrue((boolean)url.toLowerCase().startsWith("imap"), (String)"URL must start with 'imap' for the IMAP Mail receiver.");
    }

    public void setShouldDeleteMessages(boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    protected boolean shouldDeleteMessages() {
        return this.shouldDeleteMessages;
    }

    public void waitForNewMessages() throws MessagingException, InterruptedException {
        this.openFolder();
        Assert.state((boolean)(this.getFolder() instanceof IMAPFolder), (String)("folder is not an instance of [" + IMAPFolder.class.getName() + "]"));
        IMAPFolder imapFolder = (IMAPFolder)this.getFolder();
        if (imapFolder.hasNewMessages()) {
            return;
        }
        imapFolder.addMessageCountListener(this.messageCountListener);
        try {
            imapFolder.idle();
        }
        finally {
            imapFolder.removeMessageCountListener(this.messageCountListener);
        }
    }

    protected Message[] searchForNewMessages() throws MessagingException {
        Flags supportedFlags = this.getFolder().getPermanentFlags();
        Object searchTerm = null;
        if (supportedFlags != null) {
            if (supportedFlags.contains(Flags.Flag.RECENT)) {
                searchTerm = new FlagTerm(new Flags(Flags.Flag.RECENT), true);
            }
            if (supportedFlags.contains(Flags.Flag.ANSWERED)) {
                FlagTerm answeredTerm = new FlagTerm(new Flags(Flags.Flag.ANSWERED), false);
                searchTerm = searchTerm == null ? answeredTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)answeredTerm);
            }
            if (supportedFlags.contains(Flags.Flag.DELETED)) {
                FlagTerm deletedTerm = new FlagTerm(new Flags(Flags.Flag.DELETED), false);
                searchTerm = searchTerm == null ? deletedTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)deletedTerm);
            }
        }
        return searchTerm != null ? this.getFolder().search(searchTerm) : this.getFolder().getMessages();
    }

    private static class SimpleMessageCountListener
    extends MessageCountAdapter {
        private SimpleMessageCountListener() {
        }

        public void messagesAdded(MessageCountEvent event) {
            Message[] messages;
            Message[] messageArray = messages = event.getMessages();
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message message = messageArray[n2];
                try {
                    message.getLineCount();
                }
                catch (MessagingException messagingException) {}
                ++n2;
            }
        }
    }
}

