/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.util.Assert;

public class Pop3MailReceiver
extends AbstractMailReceiver {
    public Pop3MailReceiver(String url) {
        super(url);
        Assert.isTrue((boolean)url.startsWith("pop3"), (String)"url must start with 'pop3'");
    }

    public Pop3MailReceiver(String host, String username, String password) {
        this(host, -1, username, password);
    }

    public Pop3MailReceiver(String host, int port, String username, String password) {
        super(new URLName("pop3", host, port, "INBOX", username, password));
    }

    protected final boolean shouldDeleteMessages() {
        return true;
    }

    protected Message[] searchForNewMessages() throws MessagingException {
        int messageCount = this.getFolder().getMessageCount();
        if (messageCount == 0) {
            return new Message[0];
        }
        return this.getFolder().getMessages();
    }

    protected void deleteMessages(Message[] messages) throws MessagingException {
        super.deleteMessages(messages);
        int i = 0;
        while (i < messages.length) {
            new MimeMessage((MimeMessage)messages[i]);
            ++i;
        }
        MailTransportUtils.closeFolder(this.getFolder(), true);
    }
}

