/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.springframework.integration.mail.transformer.AbstractMailMessageTransformer;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.util.Assert;

public class MailToStringTransformer
extends AbstractMailMessageTransformer<String> {
    private String charset = "UTF-8";

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), () -> "unsupported charset '" + charset + "'");
        this.charset = charset;
    }

    @Override
    protected AbstractIntegrationMessageBuilder<String> doTransform(Message mailMessage) {
        try {
            String payload;
            Object content = mailMessage.getContent();
            if (content instanceof String) {
                String value;
                payload = value = (String)content;
            } else if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                multipart.writeTo((OutputStream)outputStream);
                payload = outputStream.toString(this.charset);
            } else if (content instanceof Part) {
                Part part = (Part)content;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                part.writeTo((OutputStream)outputStream);
                payload = outputStream.toString(this.charset);
            } else {
                throw new IllegalArgumentException("failed to transform contentType [" + mailMessage.getContentType() + "] to String.");
            }
            return this.getMessageBuilderFactory().withPayload((Object)payload);
        }
        catch (Exception ex) {
            throw new MessageTransformationException("Cannot transform mail message", (Throwable)ex);
        }
    }
}

