/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeMessage;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.util.Assert;

public class Pop3MailReceiver
extends AbstractMailReceiver {
    public static final String PROTOCOL = "pop3";

    public Pop3MailReceiver() {
        this.setProtocol(PROTOCOL);
    }

    public Pop3MailReceiver(String url) {
        super(url);
        if (url != null) {
            Assert.isTrue((boolean)url.startsWith(PROTOCOL), (String)"url must start with 'pop3'");
        } else {
            this.setProtocol(PROTOCOL);
        }
    }

    public Pop3MailReceiver(String host, String username, String password) {
        this(host, -1, username, password);
    }

    public Pop3MailReceiver(String host, int port, String username, String password) {
        super(new URLName(PROTOCOL, host, port, "INBOX", username, password));
    }

    @Override
    protected Message[] searchForNewMessages() throws MessagingException {
        Folder folderToUse = this.getFolder();
        int messageCount = folderToUse.getMessageCount();
        if (messageCount == 0) {
            return new Message[0];
        }
        return folderToUse.getMessages();
    }

    @Override
    protected void deleteMessages(Message[] messages) throws MessagingException {
        super.deleteMessages(messages);
        for (Message message : messages) {
            new MimeMessage((MimeMessage)message);
        }
    }
}

