/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi;

import java.io.Serializable;
import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final RequestReplyExchanger proxy;

    public RmiOutboundGateway(String url) {
        this.proxy = this.createProxy(url);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public final Object handleRequestMessage(Message<?> message) {
        if (!(message.getPayload() instanceof Serializable)) {
            throw new MessageHandlingException(message, ((Object)((Object)this)).getClass().getName() + " expects a Serializable payload type " + "but encountered [" + message.getPayload().getClass().getName() + "]");
        }
        Message requestMessage = MessageBuilder.withPayload((Object)message.getPayload()).copyHeaders((Map)message.getHeaders()).build();
        try {
            Message reply = this.proxy.exchange(requestMessage);
            if (reply != null) {
                reply = MessageBuilder.fromMessage((Message)reply).copyHeadersIfAbsent((Map)message.getHeaders()).build();
            }
            return reply;
        }
        catch (MessagingException e) {
            throw new MessageHandlingException(message, (Throwable)e);
        }
        catch (RemoteAccessException e) {
            throw new MessageHandlingException(message, "remote failure in RmiOutboundGateway", (Throwable)e);
        }
    }

    private RequestReplyExchanger createProxy(String url) {
        RmiProxyFactoryBean proxyFactory = new RmiProxyFactoryBean();
        proxyFactory.setServiceInterface(RequestReplyExchanger.class);
        proxyFactory.setServiceUrl(url);
        proxyFactory.setLookupStubOnStartup(false);
        proxyFactory.setRefreshStubOnConnectFailure(true);
        proxyFactory.afterPropertiesSet();
        return (RequestReplyExchanger)proxyFactory.getObject();
    }
}

