/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket.outbound;

import java.util.Arrays;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.rsocket.ClientRSocketConnector;
import org.springframework.integration.rsocket.RSocketInteractionModel;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RSocketOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final Expression routeExpression;
    private Object[] routeVars;
    @Nullable
    private ClientRSocketConnector clientRSocketConnector;
    private Expression interactionModelExpression = new ValueExpression((Object)RSocketInteractionModel.requestResponse);
    private Expression publisherElementTypeExpression;
    private Expression expectedResponseTypeExpression = new ValueExpression(String.class);
    private Expression metadataExpression;
    private EvaluationContext evaluationContext;
    @Nullable
    private RSocketRequester rsocketRequester;

    public RSocketOutboundGateway(String route, Object ... routeVariables) {
        this((Expression)new ValueExpression((Object)route));
        if (routeVariables != null) {
            this.routeVars = Arrays.copyOf(routeVariables, routeVariables.length);
        }
    }

    public RSocketOutboundGateway(Expression routeExpression) {
        Assert.notNull((Object)routeExpression, (String)"'routeExpression' must not be null");
        this.routeExpression = routeExpression;
        this.setAsync(true);
        this.setPrimaryExpression(this.routeExpression);
    }

    public void setClientRSocketConnector(ClientRSocketConnector clientRSocketConnector) {
        Assert.notNull((Object)clientRSocketConnector, (String)"'clientRSocketConnector' must not be null");
        this.clientRSocketConnector = clientRSocketConnector;
    }

    public void setInteractionModel(RSocketInteractionModel interactionModel) {
        this.setInteractionModelExpression((Expression)new ValueExpression((Object)interactionModel));
    }

    public void setInteractionModelExpression(Expression interactionModelExpression) {
        Assert.notNull((Object)interactionModelExpression, (String)"'interactionModelExpression' must not be null");
        this.interactionModelExpression = interactionModelExpression;
    }

    public void setPublisherElementType(Class<?> publisherElementType) {
        this.setPublisherElementTypeExpression((Expression)new ValueExpression(publisherElementType));
    }

    public void setPublisherElementTypeExpression(Expression publisherElementTypeExpression) {
        this.publisherElementTypeExpression = publisherElementTypeExpression;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        this.setExpectedResponseTypeExpression((Expression)new ValueExpression(expectedResponseType));
    }

    public void setExpectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        this.expectedResponseTypeExpression = expectedResponseTypeExpression;
    }

    public void setMetadataExpression(Expression metadataExpression) {
        this.metadataExpression = metadataExpression;
    }

    protected void doInit() {
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.clientRSocketConnector != null) {
            this.rsocketRequester = this.clientRSocketConnector.getRequester();
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        RSocketRequester requester = (RSocketRequester)requestMessage.getHeaders().get((Object)"rsocketRequester", RSocketRequester.class);
        if (requester == null) {
            requester = this.rsocketRequester;
        }
        Assert.notNull((Object)requester, () -> "The 'RSocketRequester' must be configured via 'ClientRSocketConnector' or provided in the 'rsocketRequester' request message headers.");
        return Mono.just((Object)requester).map(rSocketRequester -> this.createRequestSpec((RSocketRequester)rSocketRequester, requestMessage)).map(requestSpec -> this.prepareRetrieveSpec((RSocketRequester.RequestSpec)requestSpec, requestMessage)).flatMap(retrieveSpec -> this.performRetrieve((RSocketRequester.RetrieveSpec)retrieveSpec, requestMessage));
    }

    private RSocketRequester.RequestSpec createRequestSpec(RSocketRequester rsocketRequester, Message<?> requestMessage) {
        Map metadata;
        String route = (String)this.routeExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.notNull((Object)route, () -> "The 'routeExpression' [" + this.routeExpression + "] must not evaluate to null");
        RSocketRequester.RequestSpec requestSpec = rsocketRequester.route(route, this.routeVars);
        if (this.metadataExpression != null && !CollectionUtils.isEmpty((Map)(metadata = (Map)this.metadataExpression.getValue(this.evaluationContext, requestMessage, Map.class)))) {
            requestSpec.metadata(spec -> metadata.forEach((arg_0, arg_1) -> ((RSocketRequester.MetadataSpec)spec).metadata(arg_0, arg_1)));
        }
        return requestSpec;
    }

    private RSocketRequester.RetrieveSpec prepareRetrieveSpec(RSocketRequester.RequestSpec requestSpec, Message<?> requestMessage) {
        Object payload = requestMessage.getPayload();
        if (payload instanceof Publisher && this.publisherElementTypeExpression != null) {
            Object publisherElementType = this.evaluateExpressionForType(requestMessage, this.publisherElementTypeExpression, "publisherElementType");
            return this.prepareRequestSpecForPublisher(requestSpec, (Publisher)payload, publisherElementType);
        }
        return requestSpec.data(payload);
    }

    private RSocketRequester.RetrieveSpec prepareRequestSpecForPublisher(RSocketRequester.RequestSpec requestSpec, Publisher<?> payload, Object publisherElementType) {
        if (publisherElementType instanceof Class) {
            return requestSpec.data(payload, (Class)publisherElementType);
        }
        return requestSpec.data(payload, (ParameterizedTypeReference)publisherElementType);
    }

    private Mono<?> performRetrieve(RSocketRequester.RetrieveSpec retrieveSpec, Message<?> requestMessage) {
        RSocketInteractionModel interactionModel = this.evaluateInteractionModel(requestMessage);
        Assert.notNull((Object)((Object)interactionModel), () -> "The 'interactionModelExpression' [" + this.interactionModelExpression + "] must not evaluate to null");
        Object expectedResponseType = null;
        if (!RSocketInteractionModel.fireAndForget.equals((Object)interactionModel)) {
            expectedResponseType = this.evaluateExpressionForType(requestMessage, this.expectedResponseTypeExpression, "expectedResponseType");
        }
        switch (interactionModel) {
            case fireAndForget: {
                return retrieveSpec.send();
            }
            case requestResponse: {
                if (expectedResponseType instanceof Class) {
                    return retrieveSpec.retrieveMono((Class)expectedResponseType);
                }
                return retrieveSpec.retrieveMono((ParameterizedTypeReference)expectedResponseType);
            }
            case requestStream: 
            case requestChannel: {
                Flux result;
                ResolvableType expectedType;
                if (expectedResponseType instanceof Class) {
                    expectedType = ResolvableType.forClass((Class)((Class)expectedResponseType));
                    result = retrieveSpec.retrieveFlux((Class)expectedResponseType);
                } else {
                    expectedType = ResolvableType.forType((ParameterizedTypeReference)((ParameterizedTypeReference)expectedResponseType));
                    result = retrieveSpec.retrieveFlux((ParameterizedTypeReference)expectedResponseType);
                }
                return RSocketOutboundGateway.isVoid(expectedType) ? result.then() : Mono.just((Object)result);
            }
        }
        throw new UnsupportedOperationException("Unsupported interaction model: " + interactionModel);
    }

    private RSocketInteractionModel evaluateInteractionModel(Message<?> requestMessage) {
        Object value = this.interactionModelExpression.getValue(this.evaluationContext, requestMessage);
        if (value instanceof RSocketInteractionModel) {
            return (RSocketInteractionModel)((Object)value);
        }
        if (value instanceof String) {
            return RSocketInteractionModel.valueOf((String)value);
        }
        throw new IllegalStateException("The 'interactionModelExpression' [" + this.interactionModelExpression + "] must evaluate to 'RSocketInteractionModel' or 'String' type, but not into: '" + value + "'");
    }

    private Object evaluateExpressionForType(Message<?> requestMessage, Expression expression, String propertyName) {
        Object type = expression.getValue(this.evaluationContext, requestMessage);
        Assert.state((type instanceof Class || type instanceof String || type instanceof ParameterizedTypeReference ? 1 : 0) != 0, () -> "The '" + propertyName + "' [" + expression + "] must evaluate to 'String' (class FQN), 'Class<?>' or 'ParameterizedTypeReference<?>', not to: " + type);
        if (type instanceof String) {
            try {
                return ClassUtils.forName((String)((String)type), (ClassLoader)this.getBeanClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return type;
    }

    private static boolean isVoid(ResolvableType type) {
        return Void.class.equals((Object)type.resolve()) || Void.TYPE.equals(type.resolve());
    }
}

