/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SecuredChannelsParser
extends AbstractSingleBeanDefinitionParser {
    private static final String BASE_PACKAGE_NAME = "org.springframework.integration.security";

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.security.config.ChannelSecurityInterceptorBeanPostProcessor";
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String securityMetadataSourceBeanName = this.parseSecurityMetadataSource(element, parserContext);
        BeanDefinitionBuilder interceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.security.channel.ChannelSecurityInterceptor");
        interceptorBuilder.addConstructorArgReference(securityMetadataSourceBeanName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)interceptorBuilder, (Element)element, (String)"authentication-manager");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)interceptorBuilder, (Element)element, (String)"access-decision-manager");
        String interceptorBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)interceptorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        builder.addConstructorArgReference(interceptorBeanName);
    }

    private String parseSecurityMetadataSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.security.channel.ChannelSecurityMetadataSource");
        List accessPolicyElements = DomUtils.getChildElementsByTagName((Element)element, (String)"access-policy");
        ManagedMap patternMappings = new ManagedMap();
        for (Element accessPolicyElement : accessPolicyElements) {
            Pattern pattern = Pattern.compile(accessPolicyElement.getAttribute("pattern"));
            String sendAccess = accessPolicyElement.getAttribute("send-access");
            String receiveAccess = accessPolicyElement.getAttribute("receive-access");
            if (!StringUtils.hasText((String)sendAccess) && !StringUtils.hasText((String)receiveAccess)) {
                parserContext.getReaderContext().error("At least one of 'send-access' or 'receive-access' must be provided.", (Object)accessPolicyElement);
            }
            BeanDefinitionBuilder accessPolicyBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.security.channel.DefaultChannelAccessPolicy");
            accessPolicyBuilder.addConstructorArgValue((Object)sendAccess);
            accessPolicyBuilder.addConstructorArgValue((Object)receiveAccess);
            accessPolicyBuilder.getBeanDefinition().setRole(1);
            patternMappings.put((Object)pattern, (Object)accessPolicyBuilder.getBeanDefinition());
        }
        builder.addConstructorArgValue((Object)patternMappings);
        builder.setRole(1);
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

