/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.integration.security.channel.ChannelAccessPolicy;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.ChannelSecurityMetadataSource;
import org.springframework.messaging.MessageChannel;

public class ChannelSecurityInterceptorBeanPostProcessor
extends AbstractAutoProxyCreator {
    private final Map<String, Set<Pattern>> securityInterceptorMappings;
    private final Map<String, Map<Pattern, ChannelAccessPolicy>> accessPolicyMapping;

    public ChannelSecurityInterceptorBeanPostProcessor(Map<String, Set<Pattern>> securityInterceptorMappings) {
        this(securityInterceptorMappings, null);
    }

    public ChannelSecurityInterceptorBeanPostProcessor(Map<String, Set<Pattern>> securityInterceptorMappings, Map<String, Map<Pattern, ChannelAccessPolicy>> accessPolicyMapping) {
        this.securityInterceptorMappings = securityInterceptorMappings;
        this.accessPolicyMapping = accessPolicyMapping;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (this.accessPolicyMapping != null && bean instanceof ChannelSecurityInterceptor && this.accessPolicyMapping.containsKey(beanName)) {
            Map<Pattern, ChannelAccessPolicy> accessPolicies = this.accessPolicyMapping.get(beanName);
            ChannelSecurityMetadataSource securityMetadataSource = (ChannelSecurityMetadataSource)((ChannelSecurityInterceptor)((Object)bean)).obtainSecurityMetadataSource();
            for (Map.Entry<Pattern, ChannelAccessPolicy> entry : accessPolicies.entrySet()) {
                securityMetadataSource.addPatternMapping(entry.getKey(), entry.getValue());
            }
        }
        return bean;
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        if (MessageChannel.class.isAssignableFrom(beanClass)) {
            ArrayList<DefaultBeanFactoryPointcutAdvisor> interceptors = new ArrayList<DefaultBeanFactoryPointcutAdvisor>();
            for (Map.Entry<String, Set<Pattern>> entry : this.securityInterceptorMappings.entrySet()) {
                if (!this.isMatch(beanName, entry.getValue())) continue;
                DefaultBeanFactoryPointcutAdvisor channelSecurityInterceptor = new DefaultBeanFactoryPointcutAdvisor();
                channelSecurityInterceptor.setAdviceBeanName(entry.getKey());
                channelSecurityInterceptor.setBeanFactory(this.getBeanFactory());
                interceptors.add(channelSecurityInterceptor);
            }
            if (!interceptors.isEmpty()) {
                return interceptors.toArray();
            }
        }
        return DO_NOT_PROXY;
    }

    private boolean isMatch(String beanName, Set<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }
}

