/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedIOException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SftpSession
implements org.springframework.integration.file.remote.session.Session<ChannelSftp.LsEntry> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Session jschSession;
    private volatile ChannelSftp channel;

    public SftpSession(Session jschSession) {
        Assert.notNull((Object)jschSession, (String)"jschSession must not be null");
        this.jschSession = jschSession;
    }

    public boolean remove(String path) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)"session is not connected");
        try {
            this.channel.rm(path);
            return true;
        }
        catch (SftpException e) {
            throw new NestedIOException("Failed to remove file: " + (Object)((Object)e));
        }
    }

    public ChannelSftp.LsEntry[] list(String path) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)"session is not connected");
        try {
            Vector lsEntries = this.channel.ls(path);
            if (lsEntries != null) {
                ChannelSftp.LsEntry[] entries = new ChannelSftp.LsEntry[lsEntries.size()];
                for (int i = 0; i < lsEntries.size(); ++i) {
                    Object next = lsEntries.get(i);
                    Assert.state((boolean)(next instanceof ChannelSftp.LsEntry), (String)"expected only LsEntry instances from channel.ls()");
                    entries[i] = (ChannelSftp.LsEntry)next;
                }
                return entries;
            }
        }
        catch (SftpException e) {
            throw new NestedIOException("Failed to list files", (Throwable)e);
        }
        return new ChannelSftp.LsEntry[0];
    }

    public String[] listNames(String path) throws IOException {
        ChannelSftp.LsEntry[] entries = this.list(path);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < entries.length; ++i) {
            String fileName = entries[i].getFilename();
            SftpATTRS attrs = entries[i].getAttrs();
            if (attrs.isDir() || attrs.isLink()) continue;
            names.add(fileName);
        }
        String[] fileNames = new String[names.size()];
        return names.toArray(fileNames);
    }

    public void read(String source, OutputStream os) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)"session is not connected");
        try {
            InputStream is = this.channel.get(source);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (SftpException e) {
            throw new NestedIOException("failed to read file", (Throwable)e);
        }
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        Assert.state((this.channel != null ? 1 : 0) != 0, (String)"session is not connected");
        try {
            this.channel.put(inputStream, destination);
        }
        catch (SftpException e) {
            throw new NestedIOException("failed to write file", (Throwable)e);
        }
    }

    public void close() {
        if (this.jschSession.isConnected()) {
            this.jschSession.disconnect();
        }
    }

    public boolean isOpen() {
        return this.jschSession.isConnected();
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        try {
            this.channel.rename(pathFrom, pathTo);
        }
        catch (SftpException sftpex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initial File rename failed, possibly because file already exists. Will attempt to delete file: " + pathTo + " and execute rename again."));
            }
            try {
                this.remove(pathTo);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Delete file: " + pathTo + " succeeded. Will attempt rename again"));
                }
            }
            catch (IOException ioex) {
                throw new NestedIOException("Failed to delete file " + pathTo, (Throwable)ioex);
            }
            try {
                this.channel.rename(pathFrom, pathTo);
            }
            catch (SftpException sftpex2) {
                throw new NestedIOException("failed to rename from " + pathFrom + " to " + pathTo, (Throwable)sftpex2);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("File: " + pathFrom + " was successfully renamed to " + pathTo));
        }
    }

    public boolean mkdir(String remoteDirectory) throws IOException {
        try {
            this.channel.mkdir(remoteDirectory);
        }
        catch (SftpException e) {
            throw new NestedIOException("failed to create remote directory '" + remoteDirectory + "'.", (Throwable)e);
        }
        return true;
    }

    public boolean exists(String path) {
        try {
            this.channel.lstat(path);
            return true;
        }
        catch (SftpException sftpException) {
            return false;
        }
    }

    void connect() {
        try {
            if (!this.jschSession.isConnected()) {
                this.jschSession.connect();
                this.channel = (ChannelSftp)this.jschSession.openChannel("sftp");
            }
            if (this.channel != null && !this.channel.isConnected()) {
                this.channel.connect();
            }
        }
        catch (JSchException e) {
            throw new IllegalStateException("failed to connect", e);
        }
    }
}

