/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.message.GenericMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteStreamReadingMessageSource
implements MessageSource<byte[]> {
    private BufferedInputStream stream;
    private Object streamMonitor;
    private int bytesPerMessage = 1024;
    private boolean shouldTruncate = true;

    public ByteStreamReadingMessageSource(InputStream stream) {
        this(stream, -1);
    }

    public ByteStreamReadingMessageSource(InputStream stream, int bufferSize) {
        this.streamMonitor = stream;
        this.stream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : (bufferSize > 0 ? new BufferedInputStream(stream, bufferSize) : new BufferedInputStream(stream));
    }

    public void setBytesPerMessage(int bytesPerMessage) {
        this.bytesPerMessage = bytesPerMessage;
    }

    public void setShouldTruncate(boolean shouldTruncate) {
        this.shouldTruncate = shouldTruncate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<byte[]> receive() {
        try {
            byte[] bytes;
            int bytesRead = 0;
            Object object = this.streamMonitor;
            synchronized (object) {
                if (this.stream.available() == 0) {
                    return null;
                }
                bytes = new byte[this.bytesPerMessage];
                bytesRead = this.stream.read(bytes, 0, bytes.length);
            }
            if (bytesRead <= 0) {
                return null;
            }
            if (!this.shouldTruncate) {
                return new GenericMessage((Object)bytes);
            }
            byte[] result = new byte[bytesRead];
            System.arraycopy(bytes, 0, result, 0, result.length);
            return new GenericMessage((Object)result);
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }
}

