/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.integration.transformer.SyslogToMapTransformer;
import org.springframework.messaging.Message;

public class DefaultMessageConverter
implements MessageConverter,
BeanFactoryAware {
    private final SyslogToMapTransformer transformer = new SyslogToMapTransformer();
    public static final Set<String> SYSLOG_PAYLOAD_ENTRIES = new HashSet<String>(Arrays.asList("MESSAGE", "UNDECODED"));
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;
    private volatile boolean asMap = true;
    private BeanFactory beanFactory;

    public void setAsMap(boolean asMap) {
        this.asMap = asMap;
    }

    protected boolean asMap() {
        return this.asMap;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    @Override
    public Message<?> fromSyslog(Message<?> message) {
        Map map = (Map)this.transformer.doTransform(message);
        HashMap out = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (SYSLOG_PAYLOAD_ENTRIES.contains(key)) continue;
            out.put((CallSite)((Object)("syslog_" + (String)entry.getKey())), entry.getValue());
        }
        return this.getMessageBuilderFactory().withPayload(this.asMap ? map : message.getPayload()).copyHeaders((Map)message.getHeaders()).copyHeaders(out).build();
    }
}

