/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.springframework.integration.test.matcher.TypeSafeMatcher;

public class MapContentMatchers<T, V>
extends TypeSafeMatcher<Map<? super T, ? super V>> {
    private final T key;
    private final Matcher<V> valueMatcher;

    private MapContentMatchers(T key, V value) {
        this(key, Matchers.equalTo(value));
    }

    private MapContentMatchers(T key, Matcher<V> valueMatcher) {
        this.key = key;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matchesSafely(Map<? super T, ? super V> item) {
        return item.containsKey(this.key) && this.valueMatcher.matches(item.get(this.key));
    }

    public void describeTo(Description description) {
        description.appendText("an entry with key ").appendValue(this.key).appendText(" and value matching ").appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasEntry(T key, V value) {
        return new MapContentMatchers<T, V>(key, value);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasEntry(T key, Matcher<V> valueMatcher) {
        return new MapContentMatchers<T, V>(key, valueMatcher);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasKey(T key) {
        return new MapContentMatchers<T, V>(key, Matchers.anything());
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasAllEntries(Map<T, V> entries) {
        ArrayList<Matcher<Map<T, V>>> matchers = new ArrayList<Matcher<Map<T, V>>>(entries.size());
        for (Map.Entry<T, V> entry : entries.entrySet()) {
            V value = entry.getValue();
            if (value instanceof Matcher) {
                matchers.add(MapContentMatchers.hasEntry(entry.getKey(), (Matcher)value));
                continue;
            }
            matchers.add(MapContentMatchers.hasEntry(entry.getKey(), value));
        }
        return new AllOf(matchers);
    }
}

