/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.springframework.integration.test.matcher.TypeSafeMatcher;
import org.springframework.messaging.Message;

public class PayloadMatcher
extends TypeSafeMatcher<Message<?>> {
    private final Matcher<?> matcher;

    private PayloadMatcher(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matchesSafely(Message<?> message) {
        return this.matcher.matches(message.getPayload());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with payload: ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <T> Matcher<Message<?>> hasPayload(T payload) {
        return new PayloadMatcher(IsEqual.equalTo(payload));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasPayload(Matcher<? super T> payloadMatcher) {
        return new PayloadMatcher(payloadMatcher);
    }
}

