/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Date;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.springframework.integration.test.matcher.MapContentMatchers;
import org.springframework.messaging.Message;

public class HeaderMatcher<T>
extends TypeSafeMatcher<Message<T>> {
    private final Matcher<?> matcher;

    private HeaderMatcher(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    public boolean matchesSafely(Message<T> item) {
        return this.matcher.matches((Object)item.getHeaders());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers containing ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <P, V> HeaderMatcher<P> hasHeader(String key, V value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry(key, value));
    }

    @Factory
    public static <P, V> HeaderMatcher<P> hasHeader(String key, Matcher<V> valueMatcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry(key, valueMatcher));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasHeaderKey(String key) {
        return new HeaderMatcher(MapContentMatchers.hasKey(key));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasAllHeaders(Map<String, ?> entries) {
        return new HeaderMatcher(MapContentMatchers.hasAllEntries(entries));
    }

    @Factory
    public static <P, V> HeaderMatcher<P> hasMessageId(V value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("id", value));
    }

    @Factory
    public static <P, V> HeaderMatcher<P> hasCorrelationId(V value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("correlationId", value));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasSequenceNumber(Integer value) {
        return HeaderMatcher.hasSequenceNumber((Matcher<Integer>)CoreMatchers.is((Object)value));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasSequenceNumber(Matcher<Integer> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("sequenceNumber", matcher));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasSequenceSize(Integer value) {
        return HeaderMatcher.hasSequenceSize((Matcher<Integer>)CoreMatchers.is((Object)value));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasSequenceSize(Matcher<Integer> value) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("sequenceSize", value));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasExpirationDate(Date value) {
        return HeaderMatcher.hasExpirationDate((Matcher<Long>)CoreMatchers.is((Object)value.getTime()));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasExpirationDate(Matcher<Long> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("expirationDate", matcher));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasTimestamp(Date value) {
        return HeaderMatcher.hasTimestamp((Matcher<Long>)CoreMatchers.is((Object)value.getTime()));
    }

    @Factory
    public static <P> HeaderMatcher<P> hasTimestamp(Matcher<Long> matcher) {
        return new HeaderMatcher(MapContentMatchers.hasEntry("timestamp", matcher));
    }
}

