/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

@Deprecated
public final class SocketUtils {
    public static final int DEFAULT_PORT_RANGE_MIN = 10000;
    public static final int DEFAULT_PORT_RANGE_MAX = 60000;

    private SocketUtils() {
    }

    public static int findAvailableServerSocket(int seed) {
        List<Integer> openPorts = SocketUtils.findAvailableServerSockets(seed, 1);
        return openPorts.get(0);
    }

    public static List<Integer> findAvailableServerSockets(int seed, int numberOfRequestedPorts) {
        Assert.isTrue((seed >= 0 ? 1 : 0) != 0, (String)"'seed' must not be negative");
        Assert.isTrue((numberOfRequestedPorts > 0 ? 1 : 0) != 0, (String)"'numberOfRequestedPorts' must not be negative");
        ArrayList<Integer> openPorts = new ArrayList<Integer>(numberOfRequestedPorts);
        int i = seed;
        while (i < seed + 200) {
            try {
                ServerSocket sock = ServerSocketFactory.getDefault().createServerSocket(i, 1, InetAddress.getByName("localhost"));
                sock.close();
                openPorts.add(i == 0 ? sock.getLocalPort() : i);
                if (openPorts.size() == numberOfRequestedPorts) {
                    return openPorts;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            i = i == 0 ? i : i + 1;
        }
        throw new IllegalStateException(String.format("Cannot find a free server socket (%s requested)", numberOfRequestedPorts));
    }

    public static int findAvailableServerSocket() {
        int seed = SocketUtils.getRandomSeedPort();
        return SocketUtils.findAvailableServerSocket(seed);
    }

    public static int findAvailableUdpSocket(int seed) {
        List<Integer> openPorts = SocketUtils.findAvailableUdpSockets(seed, 1);
        return openPorts.get(0);
    }

    public static List<Integer> findAvailableUdpSockets(int seed, int numberOfRequestedPorts) {
        Assert.isTrue((seed >= 0 ? 1 : 0) != 0, (String)"'seed' must not be negative");
        Assert.isTrue((numberOfRequestedPorts > 0 ? 1 : 0) != 0, (String)"'numberOfRequestedPorts' must not be negative");
        ArrayList<Integer> openPorts = new ArrayList<Integer>(numberOfRequestedPorts);
        for (int i = seed; i < seed + 200; ++i) {
            try {
                DatagramSocket sock = new DatagramSocket(i, InetAddress.getByName("localhost"));
                sock.close();
                Thread.sleep(100L);
                openPorts.add(i);
                if (openPorts.size() != numberOfRequestedPorts) continue;
                return openPorts;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException(String.format("Cannot find a free server socket (%s requested)", numberOfRequestedPorts));
    }

    public static int findAvailableUdpSocket() {
        int seed = SocketUtils.getRandomSeedPort();
        return SocketUtils.findAvailableUdpSocket(seed);
    }

    public static int getRandomSeedPort() {
        return new Random().nextInt(50001) + 10000;
    }
}

