/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.support;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.test.support.RequestResponseScenario;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=SpringJUnit4ClassRunner.class)
public abstract class AbstractRequestResponseScenarioTests {
    private List<RequestResponseScenario> scenarios = null;
    @Autowired
    private ApplicationContext applicationContext;

    @Before
    public void setUp() {
        this.scenarios = this.defineRequestResponseScenarios();
    }

    @Test
    public void testRequestResponseScenarios() {
        int i = 1;
        for (RequestResponseScenario scenario : this.scenarios) {
            String name = scenario.getName() == null ? "scenario-" + i++ : scenario.getName();
            scenario.init();
            MessageChannel inputChannel = (MessageChannel)this.applicationContext.getBean(scenario.getInputChannelName(), MessageChannel.class);
            MessageChannel outputChannel = (MessageChannel)this.applicationContext.getBean(scenario.getOutputChannelName(), MessageChannel.class);
            if (outputChannel instanceof SubscribableChannel) {
                ((SubscribableChannel)outputChannel).subscribe(scenario.getResponseValidator());
            }
            Assert.assertTrue((String)(name + ": message not sent on " + scenario.getInputChannelName()), (boolean)inputChannel.send(scenario.getMessage()));
            if (outputChannel instanceof PollableChannel) {
                Message response = ((PollableChannel)outputChannel).receive(10000L);
                Assert.assertNotNull((String)(name + ": receive timeout on " + scenario.getOutputChannelName()), (Object)response);
                scenario.getResponseValidator().handleMessage(response);
            }
            Assert.assertNotNull((String)("message was not handled on " + outputChannel + " for scenario '" + scenario.getName() + "'."), scenario.getResponseValidator().getLastMessage());
        }
    }

    protected abstract List<RequestResponseScenario> defineRequestResponseScenarios();
}

