/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.springframework.util.ObjectUtils;

public class EqualsResultMatcher<U>
extends DiagnosingMatcher<U> {
    private final Evaluator<U> evaluator;

    public EqualsResultMatcher(Evaluator<U> evaluator) {
        this.evaluator = evaluator;
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        return ObjectUtils.nullSafeEquals((Object)item, this.evaluator.evaluate());
    }

    public void describeTo(Description description) {
    }

    public static <U> EqualsResultMatcher<U> equalsResult(Evaluator<U> evaluator) {
        return new EqualsResultMatcher<U>(evaluator);
    }

    public static interface Evaluator<U> {
        public U evaluate();
    }
}

