/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class LogAdjustingTestSupport {
    @Rule
    public TestName testName = new TestName();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Collection<Logger> loggersToAdjust = new ArrayList<Logger>();
    private final Collection<Level> oldCategories = new ArrayList<Level>();

    public LogAdjustingTestSupport() {
        this("org.springframework.integration");
    }

    public LogAdjustingTestSupport(String ... loggersToAdjust) {
        for (String loggerToAdjust : loggersToAdjust) {
            this.loggersToAdjust.add(LogManager.getLogger((String)loggerToAdjust));
        }
    }

    @Before
    public void beforeTest() {
        for (Logger loggerToAdjust : this.loggersToAdjust) {
            this.oldCategories.add(loggerToAdjust.getEffectiveLevel());
            loggerToAdjust.setLevel(Level.TRACE);
        }
        this.logger.debug((Object)("!!!! Starting test: " + this.testName.getMethodName() + " !!!!"));
    }

    @After
    public void afterTest() {
        this.logger.debug((Object)("!!!! Finished test: " + this.testName.getMethodName() + " !!!!"));
        Iterator<Level> oldCategory = this.oldCategories.iterator();
        for (Logger loggerToAdjust : this.loggersToAdjust) {
            loggerToAdjust.setLevel(oldCategory.next());
        }
    }
}

