/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.twitter.inbound.DirectMessageReceivingMessageSource;
import org.springframework.integration.twitter.inbound.MentionsReceivingMessageSource;
import org.springframework.integration.twitter.inbound.SearchReceivingMessageSource;
import org.springframework.integration.twitter.inbound.TimelineReceivingMessageSource;
import org.springframework.social.twitter.api.impl.TwitterTemplate;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        Class<?> clazz = TwitterInboundChannelAdapterParser.determineClass(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(clazz);
        String templateBeanName = element.getAttribute("twitter-template");
        if (StringUtils.hasText((String)templateBeanName)) {
            builder.addConstructorArgReference(templateBeanName);
        } else {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TwitterTemplate.class);
            builder.addConstructorArgValue((Object)templateBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"query");
        return builder.getBeanDefinition();
    }

    private static Class<?> determineClass(Element element, ParserContext parserContext) {
        Class clazz = null;
        String elementName = element.getLocalName().trim();
        if ("inbound-channel-adapter".equals(elementName)) {
            clazz = TimelineReceivingMessageSource.class;
        } else if ("dm-inbound-channel-adapter".equals(elementName)) {
            clazz = DirectMessageReceivingMessageSource.class;
        } else if ("mentions-inbound-channel-adapter".equals(elementName)) {
            clazz = MentionsReceivingMessageSource.class;
        } else if ("search-inbound-channel-adapter".equals(elementName)) {
            clazz = SearchReceivingMessageSource.class;
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return clazz;
    }
}

