/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.twitter.outbound.DirectMessageSendingMessageHandler;
import org.springframework.integration.twitter.outbound.StatusUpdatingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class TwitterOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        Class<?> clazz = TwitterOutboundChannelAdapterParser.determineClass(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(clazz);
        builder.addConstructorArgReference(element.getAttribute("twitter-template"));
        String tweetDataExpression = element.getAttribute("tweet-data-expression");
        if (StringUtils.hasText((String)tweetDataExpression)) {
            builder.addPropertyValue("tweetDataExpression", (Object)BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)tweetDataExpression).getBeanDefinition());
        }
        return builder.getBeanDefinition();
    }

    private static Class<?> determineClass(Element element, ParserContext parserContext) {
        Class clazz = null;
        String elementName = element.getLocalName().trim();
        if ("outbound-channel-adapter".equals(elementName)) {
            clazz = StatusUpdatingMessageHandler.class;
        } else if ("dm-outbound-channel-adapter".equals(elementName)) {
            clazz = DirectMessageSendingMessageHandler.class;
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return clazz;
    }
}

