/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.ws.transport.WebServiceMessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServiceOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final WebServiceTemplate webServiceTemplate;
    private volatile WebServiceMessageCallback requestCallback;
    private volatile boolean ignoreEmptyResponses = true;

    public AbstractWebServiceOutboundGateway(DestinationProvider destinationProvider, WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)destinationProvider, (String)"DestinationProvider must not be null");
        this.webServiceTemplate = messageFactory != null ? new WebServiceTemplate(messageFactory) : new WebServiceTemplate();
        this.webServiceTemplate.setDestinationProvider(destinationProvider);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public void setIgnoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.webServiceTemplate.setMessageFactory(messageFactory);
    }

    public void setRequestCallback(WebServiceMessageCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public void setFaultMessageResolver(FaultMessageResolver faultMessageResolver) {
        this.webServiceTemplate.setFaultMessageResolver(faultMessageResolver);
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.webServiceTemplate.setMessageSender(messageSender);
    }

    public void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        this.webServiceTemplate.setMessageSenders(messageSenders);
    }

    public void setInterceptors(ClientInterceptor[] interceptors) {
        this.webServiceTemplate.setInterceptors(interceptors);
    }

    protected WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public final Object handleRequestMessage(Message<?> message) {
        Object responsePayload = this.doHandle(message.getPayload(), this.getRequestCallback(message));
        if (responsePayload != null) {
            boolean shouldIgnore;
            boolean bl = shouldIgnore = this.ignoreEmptyResponses && responsePayload instanceof String && !StringUtils.hasText((String)((String)responsePayload));
            if (!shouldIgnore) {
                return responsePayload;
            }
        }
        return null;
    }

    protected abstract Object doHandle(Object var1, WebServiceMessageCallback var2);

    private WebServiceMessageCallback getRequestCallback(Message<?> requestMessage) {
        String soapAction = (String)requestMessage.getHeaders().get((Object)"ws_soapAction", String.class);
        return soapAction != null ? new TypeCheckingSoapActionCallback(soapAction, this.requestCallback) : this.requestCallback;
    }

    private static class TypeCheckingSoapActionCallback
    extends SoapActionCallback {
        private final WebServiceMessageCallback callbackDelegate;

        TypeCheckingSoapActionCallback(String soapAction, WebServiceMessageCallback callbackDelegate) {
            super(soapAction);
            this.callbackDelegate = callbackDelegate;
        }

        public void doWithMessage(WebServiceMessage message) throws IOException {
            if (message instanceof SoapMessage) {
                super.doWithMessage(message);
            }
            if (this.callbackDelegate != null) {
                try {
                    this.callbackDelegate.doWithMessage(message);
                }
                catch (Exception e) {
                    throw new MessagingException("error occurred in WebServiceMessageCallback", (Throwable)e);
                }
            }
        }
    }
}

