/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.config;

import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundGatewayParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class WebServiceOutboundGatewayParser
extends AbstractOutboundGatewayParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.ws";

    protected String getGatewayClassName(Element element) {
        String simpleClassName = StringUtils.hasText((String)element.getAttribute("marshaller")) ? "MarshallingWebServiceOutboundGateway" : "SimpleWebServiceOutboundGateway";
        return "org.springframework.integration.ws." + simpleClassName;
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getGatewayClassName(element));
        this.buildDestinationProvider(builder, element, parserContext);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"ignore-empty-responses");
        this.postProcessGateway(builder, element, parserContext);
        return builder;
    }

    private void buildDestinationProvider(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String uri = element.getAttribute("uri");
        String destinationProvider = element.getAttribute("destination-provider");
        if (!(StringUtils.hasText((String)destinationProvider) ^ StringUtils.hasText((String)uri))) {
            parserContext.getReaderContext().error("Exactly one of 'uri' or 'destination-provider' is required.", (Object)element);
            return;
        }
        if (StringUtils.hasText((String)destinationProvider)) {
            builder.addConstructorArgReference(destinationProvider);
        } else {
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addGenericArgumentValue((Object)uri);
            builder.addConstructorArgValue((Object)new RootBeanDefinition("org.springframework.integration.ws.config.FixedUriDestinationProvider", cavs, null));
        }
    }

    protected void postProcessGateway(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String faultMessageResolverRef;
        String requestCallbackRef;
        String marshallerRef = element.getAttribute("marshaller");
        if (StringUtils.hasText((String)marshallerRef)) {
            builder.addConstructorArgReference(marshallerRef);
            String unmarshallerRef = element.getAttribute("unmarshaller");
            if (StringUtils.hasText((String)unmarshallerRef)) {
                builder.addConstructorArgReference(unmarshallerRef);
            }
        } else {
            String sourceExtractorRef = element.getAttribute("source-extractor");
            if (StringUtils.hasText((String)sourceExtractorRef)) {
                builder.addConstructorArgReference(sourceExtractorRef);
            } else {
                builder.addConstructorArgValue(null);
            }
        }
        String messageFactoryRef = element.getAttribute("message-factory");
        if (StringUtils.hasText((String)messageFactoryRef)) {
            builder.addConstructorArgReference(messageFactoryRef);
        }
        if (StringUtils.hasText((String)(requestCallbackRef = element.getAttribute("request-callback")))) {
            builder.addPropertyReference("requestCallback", requestCallbackRef);
        }
        if (StringUtils.hasText((String)(faultMessageResolverRef = element.getAttribute("fault-message-resolver")))) {
            builder.addPropertyReference("faultMessageResolver", faultMessageResolverRef);
        }
        String messageSenderRef = element.getAttribute("message-sender");
        String messageSenderListRef = element.getAttribute("message-senders");
        if (StringUtils.hasText((String)messageSenderRef) && StringUtils.hasText((String)messageSenderListRef)) {
            parserContext.getReaderContext().error("Only one of message-sender or message-senders should be specified.", (Object)element);
        }
        if (StringUtils.hasText((String)messageSenderRef)) {
            builder.addPropertyReference("messageSender", messageSenderRef);
        }
        if (StringUtils.hasText((String)messageSenderListRef)) {
            builder.addPropertyReference("messageSenders", messageSenderListRef);
        }
        String interceptorRef = element.getAttribute("interceptor");
        String interceptorListRef = element.getAttribute("interceptors");
        if (StringUtils.hasText((String)interceptorRef) && StringUtils.hasText((String)interceptorListRef)) {
            parserContext.getReaderContext().error("Only one of interceptor or interceptors should be specified.", (Object)element);
        }
        if (StringUtils.hasText((String)interceptorRef)) {
            ManagedList interceptors = new ManagedList();
            interceptors.add((Object)new RuntimeBeanReference(interceptorRef));
            builder.addPropertyValue("interceptors", (Object)interceptors);
        }
        if (StringUtils.hasText((String)interceptorListRef)) {
            builder.addPropertyReference("interceptors", interceptorListRef);
        }
    }
}

