/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import org.springframework.integration.Message;
import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.support.MarshallingUtils;

public class MarshallingWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    private volatile Marshaller marshaller;
    private volatile Unmarshaller unmarshaller;

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller, WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        this.configureMarshallers(marshaller, unmarshaller);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller) {
        this(destinationProvider, marshaller, unmarshaller, null);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, WebServiceMessageFactory messageFactory) {
        this(destinationProvider, marshaller, null, messageFactory);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller) {
        this(destinationProvider, marshaller, (WebServiceMessageFactory)null);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller, Unmarshaller unmarshaller, WebServiceMessageFactory messageFactory) {
        super(uri, messageFactory);
        this.configureMarshallers(marshaller, unmarshaller);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller, Unmarshaller unmarshaller) {
        this(uri, marshaller, unmarshaller, null);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller, WebServiceMessageFactory messageFactory) {
        this(uri, marshaller, null, messageFactory);
    }

    public MarshallingWebServiceOutboundGateway(String uri, Marshaller marshaller) {
        this(uri, marshaller, (WebServiceMessageFactory)null);
    }

    private void configureMarshallers(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (unmarshaller == null) {
            Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller, (String)("Marshaller [" + marshaller + "] does not implement the Unmarshaller interface. " + "Please set an Unmarshaller explicitly by using one of the constructors that accepts " + "both Marshaller and Unmarshaller arguments."));
            unmarshaller = (Unmarshaller)marshaller;
        }
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    @Override
    protected Object doHandle(String uri, Message<?> requestMessage, WebServiceMessageCallback requestCallback) {
        Object reply = this.getWebServiceTemplate().sendAndReceive(uri, (WebServiceMessageCallback)new MarshallingRequestMessageCallback(requestCallback, requestMessage), (WebServiceMessageExtractor)new MarshallingResponseMessageExtractor());
        return reply;
    }

    private class MarshallingResponseMessageExtractor
    extends AbstractWebServiceOutboundGateway.ResponseMessageExtractor {
        private MarshallingResponseMessageExtractor() {
        }

        @Override
        public Object doExtractData(WebServiceMessage message) throws IOException {
            return MarshallingUtils.unmarshal((Unmarshaller)MarshallingWebServiceOutboundGateway.this.unmarshaller, (WebServiceMessage)message);
        }
    }

    private class MarshallingRequestMessageCallback
    extends AbstractWebServiceOutboundGateway.RequestMessageCallback {
        public MarshallingRequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            super(requestCallback, requestMessage);
        }

        @Override
        public void doWithMessageInternal(WebServiceMessage message, Object payload) throws IOException {
            MarshallingUtils.marshal((Marshaller)MarshallingWebServiceOutboundGateway.this.marshaller, (Object)payload, (WebServiceMessage)message);
        }
    }
}

