/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpressionParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        return XPathExpressionFactory.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String expression = element.getAttribute("expression");
        Assert.hasText((String)expression, (String)"The 'expression' attribute is required.");
        String nsPrefix = element.getAttribute("ns-prefix");
        String nsUri = element.getAttribute("ns-uri");
        String namespaceMapRef = element.getAttribute("namespace-map");
        boolean prefixProvided = StringUtils.hasText((String)nsPrefix);
        boolean namespaceProvided = StringUtils.hasText((String)nsUri);
        boolean namespaceMapProvided = StringUtils.hasText((String)namespaceMapRef);
        if (prefixProvided || namespaceProvided) {
            Assert.isTrue((prefixProvided && namespaceProvided ? 1 : 0) != 0, (String)"Both 'ns-prefix' and 'ns-uri' must be specified if one is specified.");
            Assert.isTrue((!namespaceMapProvided ? 1 : 0) != 0, (String)"It is not valid to specify both namespace and namespace-map.");
        }
        builder.setFactoryMethod("createXPathExpression");
        builder.addConstructorArgValue((Object)expression);
        if (prefixProvided) {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            namespaceMap.put(nsPrefix, nsUri);
            builder.addConstructorArgValue(namespaceMap);
        } else if (StringUtils.hasText((String)namespaceMapRef)) {
            builder.addConstructorArgReference(namespaceMapRef);
        } else if (element.getChildNodes().getLength() > 0) {
            NodeList nodeList = element.getChildNodes();
            Element mapElement = null;
            int elementCount = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                if (currentNode.getNodeType() != 1) continue;
                mapElement = (Element)currentNode;
                ++elementCount;
            }
            Assert.isTrue((elementCount == 1 ? 1 : 0) != 0, (String)"only one namespace map child allowed");
            if (mapElement != null) {
                builder.addConstructorArgValue(this.parseNamespaceMapElement(mapElement, parserContext, (BeanDefinition)builder.getBeanDefinition()));
            }
        }
    }

    protected Map<?, ?> parseNamespaceMapElement(Element element, ParserContext parserContext, BeanDefinition parentDefinition) {
        BeanDefinitionParserDelegate beanParser = new BeanDefinitionParserDelegate(parserContext.getReaderContext());
        beanParser.initDefaults(element.getOwnerDocument().getDocumentElement());
        return beanParser.parseMapElement(element, parentDefinition);
    }
}

