/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.source;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.MessagingException;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class StringSourceFactory
implements SourceFactory {
    private final TransformerFactory transformerFactory;

    public StringSourceFactory() {
        this(TransformerFactory.newInstance());
    }

    public StringSourceFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Source createSource(Object payload) {
        StringSource source = null;
        if (payload instanceof String) {
            source = new StringSource((String)payload);
        } else if (payload instanceof Document) {
            source = this.createStringSourceForDocument((Document)payload);
        } else if (payload instanceof File) {
            source = this.createStringSourceForFile((File)payload);
        }
        if (source == null) {
            throw new MessagingException("Failed to create Source for payload type [" + payload.getClass().getName() + "]");
        }
        return source;
    }

    private StringSource createStringSourceForDocument(Document document) {
        try {
            StringResult result = new StringResult();
            Transformer transformer = this.getTransformer();
            transformer.transform(new DOMSource(document), (Result)result);
            return new StringSource(result.toString());
        }
        catch (Exception e) {
            throw new MessagingException("failed to create StringSource from document", (Throwable)e);
        }
    }

    private StringSource createStringSourceForFile(File file) {
        try {
            String content = FileCopyUtils.copyToString((Reader)new FileReader(file));
            return new StringSource(content);
        }
        catch (Exception e) {
            throw new MessagingException("failed to create StringSource from file", (Throwable)e);
        }
    }

    private synchronized Transformer getTransformer() {
        try {
            return this.transformerFactory.newTransformer();
        }
        catch (Exception e) {
            throw new MessagingException("Exception creating transformer", (Throwable)e);
        }
    }
}

