/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml;

import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.MessagingException;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DefaultXmlPayloadConverter
implements XmlPayloadConverter {
    private DocumentBuilderFactory documentBuilderFactory;

    public DefaultXmlPayloadConverter() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public DefaultXmlPayloadConverter(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    @Override
    public Document convertToDocument(Object object) {
        if (object instanceof Document) {
            return (Document)object;
        }
        if (object instanceof File) {
            try {
                return this.getDocumentBuilder().parse((File)object);
            }
            catch (Exception e) {
                throw new MessagingException("failed to parse File payload '" + object + "'", (Throwable)e);
            }
        }
        if (object instanceof String) {
            try {
                return this.getDocumentBuilder().parse(new InputSource(new StringReader((String)object)));
            }
            catch (Exception e) {
                throw new MessagingException("failed to parse String payload '" + object + "'", (Throwable)e);
            }
        }
        throw new MessagingException("unsupported payload type [" + object.getClass().getName() + "]");
    }

    @Override
    public Node convertToNode(Object object) {
        Node node = null;
        node = object instanceof Node ? (Node)object : (object instanceof DOMSource ? ((DOMSource)object).getNode() : this.convertToDocument(object));
        return node;
    }

    @Override
    public Source convertToSource(Object object) {
        Source source = null;
        if (object instanceof Source) {
            source = (Source)object;
        } else if (object instanceof Document) {
            source = new DOMSource((Document)object);
        } else if (object instanceof String) {
            source = new StringSource((String)object);
        } else {
            throw new MessagingException("unsupported payload type [" + object.getClass().getName() + "]");
        }
        return source;
    }

    protected synchronized DocumentBuilder getDocumentBuilder() {
        try {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("failed to create a new DocumentBuilder", (Throwable)e);
        }
    }
}

