/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractXmppInboundChannelAdapterParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String connectionName = element.getAttribute("xmpp-connection");
        if (StringUtils.hasText((String)connectionName)) {
            builder.addConstructorArgReference(connectionName);
        } else if (parserContext.getRegistry().containsBeanDefinition("xmppConnection")) {
            builder.addConstructorArgReference("xmppConnection");
        } else {
            throw new BeanCreationException("You must either explicitly define which XMPP connection to use via 'xmpp-connection' attribute or have default XMPP connection bean registered under the name 'xmppConnection'(e.g., <int-xmpp:xmpp-connection .../>). If 'id' is not provided the default will be 'xmppConnection'.");
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        this.postProcess(element, parserContext, builder);
    }

    protected void postProcess(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
    }
}

