/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractXmppOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getHandlerClassName());
        String connectionName = element.getAttribute("xmpp-connection");
        if (StringUtils.hasText((String)connectionName)) {
            builder.addConstructorArgReference(connectionName);
        } else if (parserContext.getRegistry().containsBeanDefinition("xmppConnection")) {
            builder.addConstructorArgReference("xmppConnection");
        } else {
            throw new BeanCreationException("You must either explicitly define which XMPP connection to use via 'xmpp-connection' attribute or have default XMPP connection bean registered under the name 'xmppConnection'(e.g., <int-xmpp:xmpp-connection .../>). If 'id' is not provided the default will be 'xmppConnection'.");
        }
        return builder.getBeanDefinition();
    }

    protected abstract String getHandlerClassName();
}

