/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.inbound;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareEndpoint;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChatMessageListeningEndpoint
extends AbstractXmppConnectionAwareEndpoint {
    private volatile boolean extractPayload = true;
    private final PacketListener packetListener = new ChatMessagePublishingPacketListener();

    public ChatMessageListeningEndpoint() {
    }

    public ChatMessageListeningEndpoint(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "xmpp:inbound-channel-adapter";
    }

    protected void doStart() {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + " [" + this.getComponentType() + "] must be initialized"));
        this.xmppConnection.addPacketListener(this.packetListener, null);
    }

    protected void doStop() {
        if (this.xmppConnection != null) {
            this.xmppConnection.removePacketListener(this.packetListener);
        }
    }

    private class ChatMessagePublishingPacketListener
    implements PacketListener {
        private ChatMessagePublishingPacketListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message xmppMessage = (Message)packet;
                Chat chat = ChatMessageListeningEndpoint.this.xmppConnection.getChatManager().getThreadChat(xmppMessage.getThread());
                String messageBody = xmppMessage.getBody();
                if (StringUtils.hasText((String)messageBody)) {
                    String payload = ChatMessageListeningEndpoint.this.extractPayload ? messageBody : xmppMessage;
                    MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)payload).setHeader("xmpp_type", (Object)xmppMessage.getType()).setHeader("xmpp_chatKey", (Object)chat);
                    ChatMessageListeningEndpoint.this.sendMessage(messageBuilder.build());
                }
            }
        }
    }
}

