/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.outbound;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatMessageSendingMessageHandler
extends AbstractXmppConnectionAwareMessageHandler {
    public ChatMessageSendingMessageHandler() {
    }

    public ChatMessageSendingMessageHandler(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + "#" + this.getComponentType() + " must be initialized"));
        Object messageBody = message.getPayload();
        org.jivesoftware.smack.packet.Message xmppMessage = null;
        if (messageBody instanceof org.jivesoftware.smack.packet.Message) {
            xmppMessage = (org.jivesoftware.smack.packet.Message)messageBody;
        } else if (messageBody instanceof String) {
            String chatTo = (String)message.getHeaders().get((Object)"xmpp_chatTo", String.class);
            Assert.state((boolean)StringUtils.hasText((String)chatTo), (String)"The 'xmpp_chatTo' header must not be null");
            xmppMessage = new org.jivesoftware.smack.packet.Message(chatTo);
            String threadId = (String)message.getHeaders().get((Object)"xmpp_chatThreadId", String.class);
            if (StringUtils.hasText((String)threadId)) {
                xmppMessage.setThread(threadId);
            }
            xmppMessage.setBody((String)messageBody);
        } else {
            throw new MessageHandlingException(message, "Only payloads of type java.lang.String or org.jivesoftware.smack.packet.Message are supported. Received [" + messageBody.getClass().getName() + "]. Consider adding a Transformer prior to this adapter.");
        }
        if (!this.xmppConnection.isConnected()) {
            this.xmppConnection.connect();
        }
        this.xmppConnection.sendPacket((Packet)xmppMessage);
    }
}

