/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.inbound;

import java.util.Map;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareEndpoint;
import org.springframework.integration.xmpp.support.DefaultXmppHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChatMessageListeningEndpoint
extends AbstractXmppConnectionAwareEndpoint {
    private volatile boolean extractPayload = true;
    private final PacketListener packetListener = new ChatMessagePublishingPacketListener();
    private volatile XmppHeaderMapper headerMapper = new DefaultXmppHeaderMapper();

    public ChatMessageListeningEndpoint() {
    }

    public ChatMessageListeningEndpoint(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setHeaderMapper(XmppHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "xmpp:inbound-channel-adapter";
    }

    protected void doStart() {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + " [" + this.getComponentType() + "] must be initialized"));
        this.xmppConnection.addPacketListener(this.packetListener, null);
    }

    protected void doStop() {
        if (this.xmppConnection != null) {
            this.xmppConnection.removePacketListener(this.packetListener);
        }
    }

    private class ChatMessagePublishingPacketListener
    implements PacketListener {
        private ChatMessagePublishingPacketListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof Message) {
                Message xmppMessage = (Message)packet;
                Map mappedHeaders = ChatMessageListeningEndpoint.this.headerMapper.toHeadersFromRequest(xmppMessage);
                String messageBody = xmppMessage.getBody();
                if (StringUtils.hasText((String)messageBody)) {
                    String payload = ChatMessageListeningEndpoint.this.extractPayload ? messageBody : xmppMessage;
                    AbstractIntegrationMessageBuilder messageBuilder = ChatMessageListeningEndpoint.this.getMessageBuilderFactory().withPayload((Object)payload).copyHeaders(mappedHeaders);
                    ChatMessageListeningEndpoint.this.sendMessage(messageBuilder.build());
                }
            }
        }
    }
}

