/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.outbound;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareMessageHandler;
import org.springframework.integration.xmpp.support.DefaultXmppHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class ChatMessageSendingMessageHandler
extends AbstractXmppConnectionAwareMessageHandler {
    private static final Pattern XML_PATTERN = Pattern.compile("<(\\S[^>\\s]*)[^>]*>[^<]*</\\1>");
    private volatile XmppHeaderMapper headerMapper = new DefaultXmppHeaderMapper();
    private ExtensionElementProvider<? extends ExtensionElement> extensionProvider;

    public ChatMessageSendingMessageHandler() {
    }

    public ChatMessageSendingMessageHandler(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setHeaderMapper(XmppHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExtensionProvider(ExtensionElementProvider<? extends ExtensionElement> extensionProvider) {
        this.extensionProvider = extensionProvider;
    }

    public String getComponentType() {
        return "xmpp:outbound-channel-adapter";
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + "#" + this.getComponentType() + " must be initialized"));
        Object payload = message.getPayload();
        org.jivesoftware.smack.packet.Message xmppMessage = null;
        if (payload instanceof org.jivesoftware.smack.packet.Message) {
            xmppMessage = (org.jivesoftware.smack.packet.Message)payload;
        } else {
            String to = (String)message.getHeaders().get((Object)"xmpp_to", String.class);
            Assert.state((boolean)StringUtils.hasText((String)to), (String)"The 'xmpp_to' header must not be null");
            xmppMessage = new org.jivesoftware.smack.packet.Message(to);
            if (payload instanceof ExtensionElement) {
                xmppMessage.addExtension((ExtensionElement)payload);
            } else if (payload instanceof String) {
                if (this.extensionProvider != null) {
                    String data = (String)payload;
                    if (!XML_PATTERN.matcher(data.trim()).matches()) {
                        data = "<root>" + data + "</root>";
                    }
                    XmlPullParser xmlPullParser = PacketParserUtils.newXmppParser((Reader)new StringReader(data));
                    xmlPullParser.next();
                    ExtensionElement extension = (ExtensionElement)this.extensionProvider.parse(xmlPullParser);
                    xmppMessage.addExtension(extension);
                } else {
                    xmppMessage.setBody((String)payload);
                }
            } else {
                throw new MessageHandlingException(message, "Only payloads of type java.lang.String, org.jivesoftware.smack.packet.Message or org.jivesoftware.smack.packet.ExtensionElement are supported. Received [" + payload.getClass().getName() + "]. Consider adding a Transformer prior to this adapter.");
            }
        }
        if (this.headerMapper != null) {
            this.headerMapper.fromHeadersToRequest(message.getHeaders(), xmppMessage);
        }
        if (!this.xmppConnection.isConnected() && this.xmppConnection instanceof AbstractXMPPConnection) {
            ((AbstractXMPPConnection)this.xmppConnection).connect();
        }
        this.xmppConnection.sendStanza((Stanza)xmppMessage);
    }
}

